"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceTranactionGroupsAlerts = getServiceTranactionGroupsAlerts;
var _server = require("@kbn/observability-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _apm = require("../../../common/es_fields/apm");
var _latency_aggregation_types = require("../../../common/latency_aggregation_types");
var _apm_rule_types = require("../../../common/rules/apm_rule_types");
var _environment_query = require("../../../common/utils/environment_query");
var _get_service_transaction_groups = require("./get_service_transaction_groups");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleAggregationType = {
  [_latency_aggregation_types.LatencyAggregationType.avg]: _apm_rule_types.AggregationType.Avg,
  [_latency_aggregation_types.LatencyAggregationType.p99]: _apm_rule_types.AggregationType.P99,
  [_latency_aggregation_types.LatencyAggregationType.p95]: _apm_rule_types.AggregationType.P95
};
async function getServiceTranactionGroupsAlerts({
  apmAlertsClient,
  kuery,
  transactionType,
  serviceName,
  latencyAggregationType,
  start,
  end,
  environment
}) {
  var _response$aggregation, _buckets$map;
  const ALERT_RULE_PARAMETERS_AGGREGATION_TYPE = `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.aggregationType`;
  const params = {
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_ruleDataUtils.ALERT_RULE_PRODUCER, 'apm'), ...(0, _server.termQuery)(_ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_STATUS_ACTIVE), ...(0, _server.rangeQuery)(start, end), ...(0, _server.kqlQuery)(kuery), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _environment_query.environmentQuery)(environment)],
        must: [{
          bool: {
            should: [...(0, _server.termQuery)(ALERT_RULE_PARAMETERS_AGGREGATION_TYPE, RuleAggregationType[latencyAggregationType]), {
              bool: {
                must_not: [{
                  exists: {
                    field: ALERT_RULE_PARAMETERS_AGGREGATION_TYPE
                  }
                }]
              }
            }]
          }
        }]
      }
    },
    aggs: {
      transaction_groups: {
        terms: {
          field: _apm.TRANSACTION_NAME,
          size: _get_service_transaction_groups.MAX_NUMBER_OF_TX_GROUPS,
          order: {
            _count: 'desc'
          }
        }
      }
    }
  };
  const response = await apmAlertsClient.search(params);
  const {
    buckets
  } = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.transaction_groups;
  const servicesTransactionGroupsAlertsCount = (_buckets$map = buckets.map(bucket => ({
    name: bucket.key,
    alertsCount: bucket.doc_count
  }))) !== null && _buckets$map !== void 0 ? _buckets$map : [];
  return servicesTransactionGroupsAlertsCount;
}