"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionErrorCountChartPreview = getTransactionErrorCountChartPreview;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../../common/es_fields/apm");
var _environment_query = require("../../../../../common/utils/environment_query");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _get_all_groupby_fields = require("../../../../../common/rules/get_all_groupby_fields");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _get_filtered_series_for_preview_chart = require("../utils/get_filtered_series_for_preview_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTransactionErrorCountChartPreview({
  apmEventClient,
  alertParams
}) {
  const {
    serviceName,
    environment,
    errorGroupingKey,
    interval,
    start,
    end,
    groupBy: groupByFields
  } = alertParams;
  const allGroupByFields = (0, _get_all_groupby_fields.getAllGroupByFields)(_apm_rule_types.ApmRuleType.ErrorCount, groupByFields);
  const query = {
    bool: {
      filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName, {
        queryEmptyString: false
      }), ...(0, _server.termQuery)(_apm.ERROR_GROUP_ID, errorGroupingKey, {
        queryEmptyString: false
      }), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), {
        term: {
          [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.error
        }
      }]
    }
  };
  const aggs = {
    timeseries: {
      date_histogram: {
        field: '@timestamp',
        fixed_interval: interval,
        extended_bounds: {
          min: start,
          max: end
        }
      },
      aggs: {
        series: {
          multi_terms: {
            terms: (0, _get_groupby_terms.getGroupByTerms)(allGroupByFields),
            size: 1000,
            order: {
              _count: 'desc'
            }
          }
        }
      }
    }
  };
  const params = {
    apm: {
      events: [_common.ProcessorEvent.error]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query,
      aggs
    }
  };
  const resp = await apmEventClient.search('get_error_count_chart_preview', params);
  if (!resp.aggregations) {
    return {
      series: [],
      totalGroups: 0
    };
  }
  const seriesDataMap = resp.aggregations.timeseries.buckets.reduce((acc, bucket) => {
    const x = bucket.key;
    bucket.series.buckets.forEach(seriesBucket => {
      const bucketKey = seriesBucket.key.join('_');
      const y = seriesBucket.doc_count;
      if (acc[bucketKey]) {
        acc[bucketKey].push({
          x,
          y
        });
      } else {
        acc[bucketKey] = [{
          x,
          y
        }];
      }
    });
    return acc;
  }, {});
  const series = Object.keys(seriesDataMap).map(key => ({
    name: key,
    data: seriesDataMap[key]
  }));
  const filteredSeries = (0, _get_filtered_series_for_preview_chart.getFilteredBarSeries)(series);
  return {
    series: filteredSeries,
    totalGroups: series.length
  };
}