"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APMPlugin", {
  enumerable: true,
  get: function () {
    return _plugin.APMPlugin;
  }
});
Object.defineProperty(exports, "APM_SERVER_FEATURE_ID", {
  enumerable: true,
  get: function () {
    return _apm_rule_types.APM_SERVER_FEATURE_ID;
  }
});
exports.plugin = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("@kbn/observability-plugin/common");
var _aggregated_transactions = require("../common/aggregated_transactions");
var _plugin = require("./plugin");
var _apm_rule_types = require("../common/rules/apm_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disabledOnServerless = _configSchema.schema.conditional(_configSchema.schema.contextRef('serverless'), true, _configSchema.schema.boolean({
  defaultValue: false
}), _configSchema.schema.oneOf([_configSchema.schema.literal(true)], {
  defaultValue: true
}));

// All options should be documented in the APM configuration settings: https://github.com/elastic/kibana/blob/main/docs/settings/apm-settings.asciidoc
// and be included on cloud allow list unless there are specific reasons not to
const configSchema = _configSchema.schema.object({
  autoCreateApmDataView: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serviceMapEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serviceMapFingerprintBucketSize: _configSchema.schema.number({
    defaultValue: 100
  }),
  serviceMapFingerprintGlobalBucketSize: _configSchema.schema.number({
    defaultValue: 1000
  }),
  serviceMapTraceIdBucketSize: _configSchema.schema.number({
    defaultValue: 65
  }),
  serviceMapTraceIdGlobalBucketSize: _configSchema.schema.number({
    defaultValue: 6
  }),
  serviceMapMaxTracesPerRequest: _configSchema.schema.number({
    defaultValue: 50
  }),
  serviceMapTerminateAfter: _configSchema.schema.number({
    defaultValue: 100_000
  }),
  serviceMapMaxTraces: _configSchema.schema.number({
    defaultValue: 1000
  }),
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    maxTraceItems: _configSchema.schema.number({
      defaultValue: 5000
    })
  }),
  searchAggregatedTransactions: _configSchema.schema.oneOf([_configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.auto), _configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.always), _configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.never)], {
    defaultValue: _aggregated_transactions.SearchAggregatedTransactionSetting.auto
  }),
  telemetryCollectionEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  metricsInterval: _configSchema.schema.number({
    defaultValue: 30
  }),
  agent: _configSchema.schema.object({
    migrations: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  }),
  indices: _configSchema.schema.object({
    transaction: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*'
    }),
    span: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*'
    }),
    error: _configSchema.schema.string({
      defaultValue: 'logs-apm*,apm-*'
    }),
    metric: _configSchema.schema.string({
      defaultValue: 'metrics-apm*,apm-*'
    }),
    onboarding: _configSchema.schema.string({
      defaultValue: 'apm-*'
    })
  }),
  forceSyntheticSource: _configSchema.schema.boolean({
    defaultValue: false
  }),
  latestAgentVersionsUrl: _configSchema.schema.string({
    defaultValue: 'https://apm-agent-versions.elastic.co/versions.json'
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serverlessOnboarding: _configSchema.schema.conditional(_configSchema.schema.contextRef('serverless'), true, _configSchema.schema.boolean({
    defaultValue: false
  }), _configSchema.schema.never()),
  managedServiceUrl: _configSchema.schema.conditional(_configSchema.schema.contextRef('serverless'), true, _configSchema.schema.string({
    defaultValue: ''
  }), _configSchema.schema.never()),
  featureFlags: _configSchema.schema.object({
    agentConfigurationAvailable: disabledOnServerless,
    configurableIndicesAvailable: disabledOnServerless,
    infrastructureTabAvailable: disabledOnServerless,
    infraUiAvailable: disabledOnServerless,
    migrationToFleetAvailable: disabledOnServerless,
    sourcemapApiAvailable: disabledOnServerless,
    storageExplorerAvailable: disabledOnServerless
  })
});

// plugin config
const config = {
  deprecations: ({
    rename,
    unused,
    renameFromRoot,
    deprecateFromRoot,
    unusedFromRoot
  }) => [unused('indices.sourcemap', {
    level: 'warning'
  }), unused('ui.transactionGroupBucketSize', {
    level: 'warning'
  }), rename('autocreateApmIndexPattern', 'autoCreateApmDataView', {
    level: 'warning'
  }), renameFromRoot('apm_oss.transactionIndices', 'xpack.apm.indices.transaction', {
    level: 'warning'
  }), renameFromRoot('apm_oss.spanIndices', 'xpack.apm.indices.span', {
    level: 'warning'
  }), renameFromRoot('apm_oss.errorIndices', 'xpack.apm.indices.error', {
    level: 'warning'
  }), renameFromRoot('apm_oss.metricsIndices', 'xpack.apm.indices.metric', {
    level: 'warning'
  }), renameFromRoot('apm_oss.sourcemapIndices', 'xpack.apm.indices.sourcemap', {
    level: 'warning'
  }), renameFromRoot('apm_oss.onboardingIndices', 'xpack.apm.indices.onboarding', {
    level: 'warning'
  }), deprecateFromRoot('apm_oss.enabled', '8.0.0', {
    level: 'warning'
  }), unusedFromRoot('apm_oss.fleetMode', {
    level: 'warning'
  }), unusedFromRoot('apm_oss.indexPattern', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.maxServiceEnvironments', `uiSettings.overrides[${_common.maxSuggestions}]`, {
    level: 'warning'
  }), renameFromRoot('xpack.apm.maxServiceSelection', `uiSettings.overrides[${_common.maxSuggestions}]`, {
    level: 'warning'
  })],
  exposeToBrowser: {
    serviceMapEnabled: true,
    ui: true,
    latestAgentVersionsUrl: true,
    managedServiceUrl: true,
    serverlessOnboarding: true,
    featureFlags: true
  },
  schema: configSchema
};
exports.config = config;
const plugin = initContext => new _plugin.APMPlugin(initContext);
exports.plugin = plugin;