"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flaskVariables = exports.flaskLineNumbers = exports.flaskHighlightLang = exports.flask = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flaskVariables = {
  apmServiceName: 'SERVICE_NAME',
  secretToken: 'SECRET_TOKEN',
  apmServerUrl: 'SERVER_URL',
  apmEnvironment: 'ENVIRONMENT'
};
exports.flaskVariables = flaskVariables;
const flaskHighlightLang = 'py';
exports.flaskHighlightLang = flaskHighlightLang;
const flaskLineNumbers = {
  start: 1,
  highlight: '2-4, 7-18',
  annotations: {
    9: _shared_hints.serviceNameHint,
    11: _shared_hints.secretTokenHint,
    13: _shared_hints.serverUrlHint,
    15: _shared_hints.serviceEnvironmentHint
  }
};
exports.flaskLineNumbers = flaskLineNumbers;
const flask = `# ${_i18n.i18n.translate('xpack.apm.tutorial.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment', {
  defaultMessage: 'Initialize using environment variables'
})}
from elasticapm.contrib.flask import ElasticAPM
app = Flask(__name__)
apm = ElasticAPM(app)

# ${_i18n.i18n.translate('xpack.apm.tutorial.flaskClient.configure.commands.configureElasticApmComment', {
  defaultMessage: "Or use ELASTIC_APM in your application's settings"
})}
from elasticapm.contrib.flask import ElasticAPM
app.config['ELASTIC_APM'] = {
  '${flaskVariables.apmServiceName}': '{{{apmServiceName}}}',

  '${flaskVariables.secretToken}': '{{{secretToken}}}',

  '${flaskVariables.apmServerUrl}': '{{{apmServerUrl}}}',

  '${flaskVariables.apmEnvironment}': '{{{apmEnvironment}}}',
}

apm = ElasticAPM(app)`;
exports.flask = flask;