"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceTransactionTypesFetcher = useServiceTransactionTypesFetcher;
var _use_fetcher = require("../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DATA = {
  transactionTypes: []
};
function useServiceTransactionTypesFetcher({
  serviceName,
  start,
  end
}) {
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transaction_types', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [serviceName, start, end]);
  return {
    transactionTypes: data.transactionTypes,
    status
  };
}