"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockApmPluginContextWrapper = MockApmPluginContextWrapper;
exports.mockApmPluginContextValue = exports.infraLocatorsMock = void 0;
var _react = _interopRequireWildcard(require("react"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _reactRouterDom = require("react-router-dom");
var _history = require("history");
var _lodash = require("lodash");
var _mocks = require("@kbn/core/public/mocks");
var _url_service = require("@kbn/share-plugin/common/url_service");
var _public = require("@kbn/observability-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/ml-plugin/public");
var _mocks2 = require("@kbn/share-plugin/public/mocks");
var _apm_plugin_context = require("./apm_plugin_context");
var _create_call_apm_api = require("../../services/rest/create_call_apm_api");
var _apm_route_config = require("../../components/routing/apm_route_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const coreStart = _mocks.coreMock.createStart({
  basePath: '/basepath'
});
const mockCore = (0, _lodash.merge)({}, coreStart, {
  application: {
    capabilities: {
      apm: {},
      ml: {},
      savedObjectsManagement: {
        edit: true
      }
    }
  },
  uiSettings: {
    get: key => {
      const uiSettings = {
        [_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES]: [{
          from: 'now/d',
          to: 'now/d',
          display: 'Today'
        }, {
          from: 'now/w',
          to: 'now/w',
          display: 'This week'
        }],
        [_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS]: {
          from: 'now-15m',
          to: 'now'
        },
        [_common.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS]: {
          pause: false,
          value: 100000
        },
        [_public.enableComparisonByDefault]: true
      };
      return uiSettings[key];
    }
  }
});
const mockConfig = {
  serviceMapEnabled: true,
  ui: {
    enabled: false
  },
  latestAgentVersionsUrl: '',
  serverlessOnboarding: false,
  managedServiceUrl: '',
  featureFlags: {
    agentConfigurationAvailable: true,
    configurableIndicesAvailable: true,
    infrastructureTabAvailable: true,
    infraUiAvailable: true,
    migrationToFleetAvailable: true,
    sourcemapApiAvailable: true,
    storageExplorerAvailable: true
  }
};
const urlService = new _url_service.UrlService({
  navigate: async () => {},
  getUrl: async ({
    app,
    path
  }, {
    absolute
  }) => {
    return `${absolute ? 'http://localhost:8888' : ''}/app/${app}${path}`;
  },
  shortUrls: () => ({
    get: () => {}
  })
});
const locator = urlService.locators.create(new _public2.MlLocatorDefinition());
const mockPlugin = {
  ml: {
    locator
  },
  data: {
    query: {
      timefilter: {
        timefilter: {
          setTime: () => {},
          getTime: () => ({})
        }
      }
    }
  },
  share: {
    url: {
      locators: {
        get: jest.fn()
      }
    }
  }
};
const infraLocatorsMock = {
  logsLocator: _mocks2.sharePluginMock.createLocator(),
  nodeLogsLocator: _mocks2.sharePluginMock.createLocator()
};
exports.infraLocatorsMock = infraLocatorsMock;
const mockCorePlugins = {
  embeddable: {},
  inspector: {},
  maps: {},
  observability: {},
  observabilityShared: {},
  data: {}
};
const mockUnifiedSearch = {
  ui: {
    SearchBar: () => /*#__PURE__*/_react.default.createElement("div", {
      className: "searchBar"
    })
  }
};
const mockApmPluginContextValue = {
  appMountParameters: _mocks.coreMock.createAppMountParameters('/basepath'),
  config: mockConfig,
  core: mockCore,
  plugins: mockPlugin,
  observabilityRuleTypeRegistry: (0, _public.createObservabilityRuleTypeRegistryMock)(),
  corePlugins: mockCorePlugins,
  infra: {
    locators: infraLocatorsMock
  },
  deps: {},
  unifiedSearch: mockUnifiedSearch,
  uiActions: {
    getTriggerCompatibleActions: () => Promise.resolve([])
  }
};
exports.mockApmPluginContextValue = mockApmPluginContextValue;
function MockApmPluginContextWrapper({
  children,
  value = {},
  history
}) {
  const contextValue = (0, _lodash.merge)({}, mockApmPluginContextValue, value);
  if (contextValue.core) {
    (0, _create_call_apm_api.createCallApmApi)(contextValue.core);
  }
  const contextHistory = (0, _reactRouterDom.useHistory)();
  const usedHistory = (0, _react.useMemo)(() => {
    return history || contextHistory || (0, _history.createMemoryHistory)({
      initialEntries: ['/services/?rangeFrom=now-15m&rangeTo=now']
    });
  }, [history, contextHistory]);
  return /*#__PURE__*/_react.default.createElement(_apm_plugin_context.ApmPluginContext.Provider, {
    value: contextValue
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _apm_route_config.apmRouter,
    history: usedHistory
  }, children));
}