"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionJobsContext = void 0;
exports.AnomalyDetectionJobsContextProvider = AnomalyDetectionJobsContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _get_anomaly_detection_setup_state = require("../../../common/anomaly_detection/get_anomaly_detection_setup_state");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
var _use_license_context = require("../license/use_license_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionJobsContext = /*#__PURE__*/(0, _react.createContext)({});
exports.AnomalyDetectionJobsContext = AnomalyDetectionJobsContext;
function AnomalyDetectionJobsContextProvider({
  children
}) {
  var _core$application$cap, _data$jobs;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canGetJobs = !!((_core$application$cap = core.application.capabilities.ml) !== null && _core$application$cap !== void 0 && _core$application$cap.canGetJobs);
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('platinum'));
  const isAuthorized = !!(canGetJobs && hasValidLicense);
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!isAuthorized) {
      return;
    }
    return callApmApi(`GET /internal/apm/settings/anomaly-detection/jobs`);
  }, [isAuthorized], {
    showToastOnError: false
  });
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const environment = 'environment' in query && query.environment || _environment_filter_values.ENVIRONMENT_ALL.value;
  const anomalyDetectionSetupState = (0, _get_anomaly_detection_setup_state.getAnomalyDetectionSetupState)({
    environment,
    fetchStatus: status,
    jobs: (_data$jobs = data === null || data === void 0 ? void 0 : data.jobs) !== null && _data$jobs !== void 0 ? _data$jobs : [],
    isAuthorized
  });
  return /*#__PURE__*/_react.default.createElement(AnomalyDetectionJobsContext.Provider, {
    value: {
      anomalyDetectionJobsData: data,
      anomalyDetectionJobsStatus: status,
      anomalyDetectionJobsRefetch: refetch,
      anomalyDetectionSetupState
    }
  }, children);
}