"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanLinks = SpanLinks;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _kuery_bar = require("../kuery_bar");
var _span_links_callout = require("./span_links_callout");
var _span_links_table = require("./span_links_table");
var _use_local_storage = require("../../../hooks/use_local_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SpanLinks({
  spanLinksCount,
  traceId,
  spanId,
  processorEvent
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [selectedLinkType, setSelectedLinkType] = (0, _react.useState)(spanLinksCount.linkedChildren ? 'children' : 'parents');
  const [spanLinksCalloutDismissed, setSpanLinksCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.spanLinksCalloutDismissed', false);
  const [kuery, setKuery] = (0, _react.useState)('');
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (selectedLinkType === 'children') {
      return callApmApi('GET /internal/apm/traces/{traceId}/span_links/{spanId}/children', {
        params: {
          path: {
            traceId,
            spanId
          },
          query: {
            kuery,
            start,
            end
          }
        }
      });
    }
    return callApmApi('GET /internal/apm/traces/{traceId}/span_links/{spanId}/parents', {
      params: {
        path: {
          traceId,
          spanId
        },
        query: {
          kuery,
          start,
          end,
          processorEvent
        }
      }
    });
  }, [selectedLinkType, kuery, traceId, spanId, start, end, processorEvent]);
  const selectOptions = (0, _react.useMemo)(() => [{
    value: 'children',
    text: _i18n.i18n.translate('xpack.apm.spanLinks.combo.childrenLinks', {
      defaultMessage: 'Incoming links ({linkedChildren})',
      values: {
        linkedChildren: spanLinksCount.linkedChildren
      }
    }),
    disabled: !spanLinksCount.linkedChildren
  }, {
    value: 'parents',
    text: _i18n.i18n.translate('xpack.apm.spanLinks.combo.parentsLinks', {
      defaultMessage: 'Outgoing links ({linkedParents})',
      values: {
        linkedParents: spanLinksCount.linkedParents
      }
    }),
    disabled: !spanLinksCount.linkedParents
  }], [spanLinksCount]);
  if (!data || (0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'flex',
        justifyContent: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, !spanLinksCalloutDismissed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_span_links_callout.SpanLinksCallout, {
    dismissCallout: () => {
      setSpanLinksCalloutDismissed(true);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_kuery_bar.KueryBar, {
    onSubmit: value => {
      setKuery(value);
    },
    value: kuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "spanLinkTypeSelect",
    options: selectOptions,
    value: selectedLinkType,
    onChange: e => {
      setSelectedLinkType(e.target.value);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_span_links_table.SpanLinksTable, {
    items: data.spanLinksDetails
  })));
}