"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EQLHighlightRules = void 0;
require("brace/ext/language_tools");
var _brace = require("brace");
var _tokens = require("./tokens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextHighlightRules = (0, _brace.acequire)('ace/mode/text_highlight_rules').TextHighlightRules;
class EQLHighlightRules extends TextHighlightRules {
  constructor() {
    super();
    const fieldNameOrValueRegex = /((?:[^\s]+)|(?:".*?"))/;
    const operatorRegex = /(:|==|>|>=|<|<=|!=)/;
    const sequenceItemEnd = {
      token: _tokens.EQLToken.SequenceItemEnd,
      regex: /(\])/,
      next: 'start'
    };
    this.$rules = {
      start: [{
        token: _tokens.EQLToken.Sequence,
        regex: /(sequence by)/,
        next: 'field'
      }, {
        token: _tokens.EQLToken.SequenceItemStart,
        regex: /(\[)/,
        next: 'sequence_item'
      }, {
        token: _tokens.EQLToken.Until,
        regex: /(until)/,
        next: 'start'
      }],
      field: [{
        token: _tokens.EQLToken.Field,
        regex: fieldNameOrValueRegex,
        next: 'start'
      }],
      sequence_item: [{
        token: _tokens.EQLToken.EventType,
        regex: fieldNameOrValueRegex,
        next: 'where'
      }],
      sequence_item_end: [sequenceItemEnd],
      where: [{
        token: _tokens.EQLToken.Where,
        regex: /(where)/,
        next: 'condition'
      }],
      condition: [{
        token: _tokens.EQLToken.BoolCondition,
        regex: /(true|false)/,
        next: 'sequence_item_end'
      }, {
        token: _tokens.EQLToken.Field,
        regex: fieldNameOrValueRegex,
        next: 'comparison_operator'
      }],
      comparison_operator: [{
        token: _tokens.EQLToken.Operator,
        regex: operatorRegex,
        next: 'value_or_value_list'
      }],
      value_or_value_list: [{
        token: _tokens.EQLToken.Value,
        regex: /("([^"]+)")|([\d+\.]+)|(true|false|null)/,
        next: 'logical_operator_or_sequence_item_end'
      }, {
        token: _tokens.EQLToken.InOperator,
        regex: /(in)/,
        next: 'value_list'
      }],
      logical_operator_or_sequence_item_end: [{
        token: _tokens.EQLToken.LogicalOperator,
        regex: /(and|or|not)/,
        next: 'condition'
      }, sequenceItemEnd],
      value_list: [{
        token: _tokens.EQLToken.ValueListStart,
        regex: /(\()/,
        next: 'value_list_item'
      }],
      value_list_item: [{
        token: _tokens.EQLToken.Value,
        regex: fieldNameOrValueRegex,
        next: 'comma'
      }],
      comma: [{
        token: _tokens.EQLToken.Comma,
        regex: /,/,
        next: 'value_list_item_or_end'
      }],
      value_list_item_or_end: [{
        token: _tokens.EQLToken.Value,
        regex: fieldNameOrValueRegex,
        next: 'comma'
      }, {
        token: _tokens.EQLToken.ValueListEnd,
        regex: /\)/,
        next: 'logical_operator_or_sequence_item_end'
      }]
    };
    this.normalizeRules();
  }
}
exports.EQLHighlightRules = EQLHighlightRules;