"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstancesLatencyDistributionChart = InstancesLatencyDistributionChart;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _apm = require("../../../../../common/es_fields/apm");
var _formatters = require("../../../../../common/utils/formatters");
var _use_theme = require("../../../../hooks/use_theme");
var urlHelpers = _interopRequireWildcard(require("../../links/url_helpers"));
var _chart_container = require("../chart_container");
var _helper = require("../transaction_charts/helper");
var _custom_tooltip = require("./custom_tooltip");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InstancesLatencyDistributionChart({
  height,
  items = [],
  status,
  comparisonItems = []
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const hasData = items.length > 0;
  const theme = (0, _use_theme.useTheme)();
  const chartTheme = (0, _public.useChartTheme)();
  const maxLatency = Math.max(...items.map(item => {
    var _item$latency;
    return (_item$latency = item.latency) !== null && _item$latency !== void 0 ? _item$latency : 0;
  }));
  const latencyFormatter = (0, _formatters.getDurationFormatter)(maxLatency);
  const tooltip = {
    stickTo: 'center',
    type: _charts.TooltipType.Follow,
    snap: false,
    customTooltip: props => /*#__PURE__*/_react.default.createElement(_custom_tooltip.CustomTooltip, (0, _extends2.default)({}, props, {
      latencyFormatter: latencyFormatter
    }))
  };

  /**
   * Handle click events on the items.
   *
   * Due to how we handle filtering by using the kuery bar, it's difficult to
   * modify existing queries. If you have an existing query in the bar, this will
   * wipe it out. This is ok for now, since we probably will be replacing this
   * interaction with something nicer in a future release.
   *
   * The event object has an array two items for each point, one of which has
   * the serviceNodeName, so we flatten the list and get the items we need to
   * form a query.
   */
  const handleElementClick = event => {
    const serviceNodeNamesQuery = event.flat().flatMap(value => {
      var _datum;
      return (_datum = value.datum) === null || _datum === void 0 ? void 0 : _datum.serviceNodeName;
    }).filter(serviceNodeName => !!serviceNodeName).map(serviceNodeName => `${_apm.SERVICE_NODE_NAME}:"${serviceNodeName}"`).join(' OR ');
    urlHelpers.push(history, {
      query: {
        kuery: serviceNodeNamesQuery
      }
    });
  };

  // With a linear scale, if all the instances have similar throughput (or if
  // there's just a single instance) they'll show along the origin. Make sure
  // the x-axis domain is [0, maxThroughput].
  const maxThroughput = Math.max(...items.map(item => {
    var _item$throughput;
    return (_item$throughput = item.throughput) !== null && _item$throughput !== void 0 ? _item$throughput : 0;
  }));
  const maxComparisonThroughput = Math.max(...comparisonItems.map(item => {
    var _item$throughput2;
    return (_item$throughput2 = item.throughput) !== null && _item$throughput2 !== void 0 ? _item$throughput2 : 0;
  }));
  const xDomain = {
    min: 0,
    max: Math.max(maxThroughput, maxComparisonThroughput)
  };
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTitle', {
    defaultMessage: 'Instances latency distribution'
  }))), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: hasData,
    height: height,
    status: status,
    id: "instancesLatencyDistribution"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, tooltip), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: _charts.Position.Bottom,
    onElementClick: handleElementClick,
    showLegend: true,
    theme: chartTheme,
    xDomain: xDomain
  }), /*#__PURE__*/_react.default.createElement(_charts.BubbleSeries, {
    color: theme.eui.euiColorVis0,
    data: items,
    id: _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartLegend', {
      defaultMessage: 'Instances'
    }),
    xAccessor: item => item.throughput,
    xScaleType: _charts.ScaleType.Linear,
    yAccessors: [item => item.latency],
    yScaleType: _charts.ScaleType.Linear,
    bubbleSeriesStyle: {
      point: {
        strokeWidth: 0,
        radius: 4,
        fill: theme.eui.euiColorVis0
      }
    }
  }), !!comparisonItems.length && /*#__PURE__*/_react.default.createElement(_charts.BubbleSeries, {
    data: comparisonItems,
    id: previousPeriodLabel,
    xAccessor: item => item.throughput,
    xScaleType: _charts.ScaleType.Linear,
    yAccessors: [item => item.latency],
    yScaleType: _charts.ScaleType.Linear,
    color: theme.eui.euiColorMediumShade,
    bubbleSeriesStyle: {
      point: {
        shape: 'square',
        radius: 4,
        fill: theme.eui.euiColorLightestShade,
        stroke: theme.eui.euiColorMediumShade,
        strokeWidth: 2
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    labelFormat: _formatters.asTransactionRate,
    position: _charts.Position.Bottom
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    labelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    position: _charts.Position.Left,
    ticks: 3
  }))));
}