"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentIcon = AgentIcon;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _get_agent_icon = require("./get_agent_icon");
var _use_theme = require("../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentIcon(props) {
  const {
    agentName,
    size = 'l'
  } = props;
  const theme = (0, _use_theme.useTheme)();
  const icon = (0, _get_agent_icon.getAgentIcon)(agentName, theme.darkMode);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: size,
    title: agentName
  });
}