"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Labs = Labs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _labs_flyout = require("./labs_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Labs() {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  (0, _react.useEffect)(() => {
    if (isOpen) {
      trackApmEvent({
        metric: 'labs_open'
      });
    }
  }, [isOpen, trackApmEvent]);
  function toggleFlyoutVisibility() {
    setIsOpen(state => !state);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmLabsLabsButton",
    color: "text",
    onClick: toggleFlyoutVisibility
  }, _i18n.i18n.translate('xpack.apm.labs', {
    defaultMessage: 'Labs'
  })), isOpen && /*#__PURE__*/_react.default.createElement(_labs_flyout.LabsFlyout, {
    onClose: toggleFlyoutVisibility
  }));
}