"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmIndices = ApmIndices;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _call_api = require("../../../../services/rest/call_api");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_INDEX_LABELS = [{
  configurationName: 'error',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.errorIndicesLabel', {
    defaultMessage: 'Error Indices'
  })
}, {
  configurationName: 'onboarding',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.onboardingIndicesLabel', {
    defaultMessage: 'Onboarding Indices'
  })
}, {
  configurationName: 'span',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.spanIndicesLabel', {
    defaultMessage: 'Span Indices'
  })
}, {
  configurationName: 'transaction',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.transactionIndicesLabel', {
    defaultMessage: 'Transaction Indices'
  })
}, {
  configurationName: 'metric',
  label: _i18n.i18n.translate('xpack.apm.settings.apmIndices.metricsIndicesLabel', {
    defaultMessage: 'Metrics Indices'
  })
}];
async function saveApmIndices({
  apmIndices
}) {
  await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/settings/apm-indices/save', {
    signal: null,
    params: {
      body: apmIndices
    }
  });
  (0, _call_api.clearCache)();
}
// avoid infinite loop by initializing the state outside the component
const INITIAL_STATE = {
  apmIndexSettings: []
};
function ApmIndices() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    notifications,
    application
  } = core;
  const canSave = application.capabilities.apm.save;
  const [apmIndices, setApmIndices] = (0, _react.useState)({});
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const {
    data = INITIAL_STATE,
    refetch
  } = (0, _use_fetcher.useFetcher)(_callApmApi => {
    return _callApmApi(`GET /internal/apm/settings/apm-index-settings`);
  }, []);
  const {
    data: space
  } = (0, _use_fetcher.useFetcher)(() => {
    var _services$spaces;
    return (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.getActiveSpace();
  }, [services.spaces]);
  (0, _react.useEffect)(() => {
    setApmIndices(data.apmIndexSettings.reduce((acc, {
      configurationName,
      savedValue
    }) => ({
      ...acc,
      [configurationName]: savedValue
    }), {}));
  }, [data]);
  const handleApplyChangesEvent = async event => {
    event.preventDefault();
    setIsSaving(true);
    try {
      await saveApmIndices({
        apmIndices
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.succeeded.title', {
          defaultMessage: 'Indices applied'
        }),
        text: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.succeeded.text', {
          defaultMessage: 'The indices changes were successfully applied. These changes are reflected immediately in the APM UI'
        })
      });
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.failed.title', {
          defaultMessage: 'Indices could not be applied.'
        }),
        text: _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyChanges.failed.text', {
          defaultMessage: 'Something went wrong when applying indices. Error: {errorMessage}',
          values: {
            errorMessage: error.message
          }
        })
      });
    }
    setIsSaving(false);
  };
  const handleChangeIndexConfigurationEvent = async event => {
    const {
      name,
      value
    } = event.target;
    setApmIndices({
      ...apmIndices,
      [name]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.apmIndices.title', {
    defaultMessage: 'Indices'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.description', {
    defaultMessage: `The APM UI uses data views to query your APM indices. If you've customized the index names that APM Server writes events to, you may need to update these patterns for the APM UI to work. Settings here take precedence over those set in kibana.yml.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), (space === null || space === void 0 ? void 0 : space.name) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "spacesApp",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.apmIndices.spaceDescription",
      defaultMessage: "The index settings apply to the {spaceName} space.",
      values: {
        spaceName: /*#__PURE__*/_react.default.createElement("strong", null, space === null || space === void 0 ? void 0 : space.name)
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, APM_INDEX_LABELS.map(({
    configurationName,
    label
  }) => {
    const matchedConfiguration = data.apmIndexSettings.find(({
      configurationName: configName
    }) => configName === configurationName);
    const defaultValue = matchedConfiguration ? matchedConfiguration.defaultValue : '';
    const savedUiIndexValue = apmIndices[configurationName] || '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: configurationName,
      label: label,
      helpText: _i18n.i18n.translate('xpack.apm.settings.apmIndices.helpText', {
        defaultMessage: 'Overrides {configurationName}: {defaultValue}',
        values: {
          configurationName: `xpack.apm.indices.${configurationName}`,
          defaultValue
        }
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "apmApmIndicesFieldText",
      disabled: !canSave,
      fullWidth: true,
      name: configurationName,
      placeholder: defaultValue,
      value: savedUiIndexValue,
      onChange: handleChangeIndexConfigurationEvent
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmApmIndicesCancelButton",
    onClick: refetch
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.cancelButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _i18n.i18n.translate('xpack.apm.settings.apmIndices.noPermissionTooltipLabel', {
      defaultMessage: "Your user role doesn't have permissions to change APM indices"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmApmIndicesApplyChangesButton",
    fill: true,
    onClick: handleApplyChangesEvent,
    isLoading: isSaving,
    isDisabled: !canSave
  }, _i18n.i18n.translate('xpack.apm.settings.apmIndices.applyButton', {
    defaultMessage: 'Apply changes'
  })))))))));
}