"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dotnetVariables = exports.dotnetLineNumbers = exports.dotnetHighlightLang = exports.dotnet = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dotnetVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'SecretToken'
  }),
  ...(!secretToken && {
    apiKey: 'ApiKey'
  }),
  apmServerUrl: 'ServerUrl'
});
exports.dotnetVariables = dotnetVariables;
const dotnetHighlightLang = 'dotnet';
exports.dotnetHighlightLang = dotnetHighlightLang;
const dotnetLineNumbers = () => ({
  start: 1,
  highlight: '1-2, 4, 6, 8, 10-12'
});
exports.dotnetLineNumbers = dotnetLineNumbers;
const dotnet = `{
  "ElasticApm": {
    /// {{serviceNameHint}} ${_i18n.i18n.translate('xpack.apm.onboarding.dotnetClient.createConfig.commands.defaultServiceName', {
  defaultMessage: 'Default is the entry assembly of the application.'
})}
    "ServiceName": "<your-service-name>",
    {{^secretToken}}
    /// {{apiKeyHint}}
    "ApiKey": "{{{apiKey}}}",
    {{/secretToken}}
    {{#secretToken}}
    /// {{secretTokenHint}}
    "SecretToken": "{{{secretToken}}}",
    {{/secretToken}}
    /// {{{serverUrlHint}}}
    "ServerUrl": "{{{apmServerUrl}}}",
    /// {{{serviceEnvironmentHint}}}
    "Environment": "<your-environment>",
  }
}`;
exports.dotnet = dotnet;