"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsFound = NoResultsFound;
exports.SunburstChart = SunburstChart;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _chartIcons = require("@kbn/chart-icons");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _chart_container = require("../../../../shared/charts/chart_container");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const theme = {
  chartMargins: {
    top: 0,
    left: 0,
    bottom: 0,
    right: 0
  },
  partition: {
    minFontSize: 5,
    idealFontSizeJump: 1.1,
    outerSizeRatio: 1,
    emptySizeRatio: 0.3,
    circlePadding: 3
  }
};
function SunburstChart({
  data,
  label,
  chartKey,
  fetchStatus,
  chartWidth
}) {
  const colors = (0, _eui.euiPaletteColorBlindBehindText)({
    sortBy: 'natural'
  });
  const isDataAvailable = data && data.length > 0;
  const isLoading = fetchStatus === _use_fetcher.FETCH_STATUS.LOADING;

  // The loader needs to be wrapped inside a div with fixed height to avoid layout shift
  const ProgressLoader = /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '5px'
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    style: {
      background: 'transparent'
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    key: chartKey,
    style: {
      height: '200px',
      width: chartWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    css: (0, _react2.css)`
            font-size: ${(0, _eui.useEuiFontSize)('xs').fontSize};
          `
  }, label)), ProgressLoader, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: Boolean(isDataAvailable),
    status: fetchStatus,
    height: 200,
    id: `mostUsedChart-${chartKey}`
  }, isDataAvailable ? /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: chartKey,
    data: data,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => Number(d.docCount),
    valueGetter: "percent",
    layers: [{
      groupByRollup: d => d.key,
      nodeLabel: d => d,
      fillLabel: {
        fontWeight: 100,
        maximizeFontSize: true,
        valueFont: {
          fontWeight: 900
        }
      },
      shape: {
        fillColor: (_, sortIndex) => {
          return colors[sortIndex];
        }
      }
    }]
  })) : /*#__PURE__*/_react.default.createElement(NoResultsFound, null)));
}
const noResultsFoundStyle = (0, _react2.css)({
  height: '100%',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'center',
  justifyContent: 'center'
});
function NoResultsFound() {
  const noResultsFoundText = _i18n.i18n.translate('xpack.apm.mobile.charts.noResultsFound', {
    defaultMessage: 'No results found'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: noResultsFoundStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "mostUsedNoResultsFound",
    textAlign: "center",
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _chartIcons.IconChartDonut,
    color: "subdued",
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, noResultsFoundText)));
}