"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsTable = CorrelationsTable;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_theme = require("../../../hooks/use_theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
function CorrelationsTable({
  significantTerms,
  status,
  setPinnedSignificantTerm,
  setSelectedSignificantTerm,
  columns,
  selectedTerm,
  onTableChange,
  sorting
}) {
  const euiTheme = (0, _use_theme.useTheme)();
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const trackSelectSignificantCorrelationTerm = (0, _react.useCallback)(() => (0, _lodash.debounce)(() => trackApmEvent({
    metric: 'select_significant_term'
  }), 1000), [trackApmEvent]);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const {
    pagination,
    pageOfItems
  } = (0, _react.useMemo)(() => {
    var _significantTerms$len;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_significantTerms$len = significantTerms === null || significantTerms === void 0 ? void 0 : significantTerms.length) !== null && _significantTerms$len !== void 0 ? _significantTerms$len : 0;
    return {
      pageOfItems: significantTerms === null || significantTerms === void 0 ? void 0 : significantTerms.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      }
    };
  }, [pageIndex, pageSize, significantTerms]);
  const onChange = (0, _react.useCallback)(tableSettings => {
    const {
      index,
      size
    } = tableSettings.page;
    setPageIndex(index);
    setPageSize(size);
    onTableChange(tableSettings);
  }, [onTableChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems !== null && pageOfItems !== void 0 ? pageOfItems : [],
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? loadingText : noDataText,
    loading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? errorMessage : '',
    columns: columns,
    rowProps: term => {
      return {
        onClick: () => {
          if (setPinnedSignificantTerm) {
            setPinnedSignificantTerm(term);
          }
        },
        onMouseEnter: () => {
          setSelectedSignificantTerm(term);
          trackSelectSignificantCorrelationTerm();
        },
        onMouseLeave: () => setSelectedSignificantTerm(null),
        style: selectedTerm && selectedTerm.fieldValue === term.fieldValue && selectedTerm.fieldName === term.fieldName ? {
          backgroundColor: euiTheme.eui.euiColorLightestShade
        } : null
      };
    },
    pagination: pagination,
    onChange: onChange,
    sorting: sorting
  });
}
const loadingText = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.loadingText', {
  defaultMessage: 'Loading...'
});
const noDataText = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.noDataText', {
  defaultMessage: 'No data'
});
const errorMessage = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.errorMessage', {
  defaultMessage: 'Failed to fetch'
});