"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorState = ErrorState;
exports.LoadingState = LoadingState;
exports.NoDataState = NoDataState;
exports.TIME_LABELS = void 0;
exports.TimeLabelForData = TimeLabelForData;
exports.getDomain = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.apm.alerts.timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.apm.alerts.timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.apm.alerts.timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.apm.alerts.timeLabels.days', {
    defaultMessage: 'days'
  })
};
exports.TIME_LABELS = TIME_LABELS;
const getDomain = series => {
  const xValues = series.flatMap(item => item.data.map(d => d.x));
  const yValues = series.flatMap(item => item.data.map(d => d.y || 0));
  return {
    xMax: Math.max(...xValues),
    xMin: Math.min(...xValues),
    yMax: Math.max(...yValues),
    yMin: Math.min(...yValues)
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }
}, children);
function NoDataState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "noChartData"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.alerts.charts.noDataMessage",
    defaultMessage: "No chart data available"
  })));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "loadingData"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m"
  })));
}
function ErrorState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "chartErrorState"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.alerts.charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong"
  })));
}
function TimeLabelForData({
  lookback,
  timeLabel,
  displayedGroups,
  totalGroups
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.alerts.timeLabelForData",
    defaultMessage: "Last {lookback} {timeLabel} of data, showing {displayedGroups}/{totalGroups} groups",
    values: {
      lookback,
      timeLabel,
      displayedGroups,
      totalGroups
    }
  })));
}