"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultTransactionTypes = exports.TRANSACTION_REQUEST = void 0;
exports.getDefaultTransactionType = getDefaultTransactionType;
exports.isDefaultTransactionType = isDefaultTransactionType;
var _agent_name = require("./agent_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSACTION_PAGE_LOAD = 'page-load';
const TRANSACTION_MOBILE = 'mobile';
const TRANSACTION_REQUEST = 'request';
exports.TRANSACTION_REQUEST = TRANSACTION_REQUEST;
const defaultTransactionTypes = [TRANSACTION_REQUEST, TRANSACTION_PAGE_LOAD, TRANSACTION_MOBILE];
exports.defaultTransactionTypes = defaultTransactionTypes;
function getDefaultTransactionType(agentName) {
  if ((0, _agent_name.isRumAgentName)(agentName)) {
    return TRANSACTION_PAGE_LOAD;
  }
  if ((0, _agent_name.isMobileAgentName)(agentName)) {
    return TRANSACTION_MOBILE;
  }
  return TRANSACTION_REQUEST;
}
function isDefaultTransactionType(transactionType) {
  return defaultTransactionTypes.includes(transactionType);
}