"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllGroupByFields = void 0;
var _lodash = require("lodash");
var _apm_rule_types = require("./apm_rule_types");
var _apm = require("../es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllGroupByFields = (ruleType, ruleParamsGroupByFields = []) => {
  let predefinedGroupByFields = [];
  switch (ruleType) {
    case _apm_rule_types.ApmRuleType.TransactionDuration:
    case _apm_rule_types.ApmRuleType.TransactionErrorRate:
      predefinedGroupByFields = [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT, _apm.TRANSACTION_TYPE];
      break;
    case _apm_rule_types.ApmRuleType.ErrorCount:
      predefinedGroupByFields = [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT];
      break;
  }
  return (0, _lodash.union)(predefinedGroupByFields, ruleParamsGroupByFields);
};
exports.getAllGroupByFields = getAllGroupByFields;