"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyAlertFieldMap = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const legacyAlertFieldMap = {
  [_ruleDataUtils.ALERT_RISK_SCORE]: {
    type: 'float',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_AUTHOR]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_CREATED_AT]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_CREATED_BY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_DESCRIPTION]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_ENABLED]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_FROM]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_INTERVAL]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_LICENSE]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_NOTE]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_REFERENCES]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_RULE_ID]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_RULE_NAME_OVERRIDE]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_TO]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_TYPE]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_UPDATED_AT]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_UPDATED_BY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_VERSION]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_SEVERITY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_SUPPRESSION_DOCS_COUNT]: {
    type: 'long',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_SUPPRESSION_END]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_SUPPRESSION_FIELD]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_SUPPRESSION_START]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_SUPPRESSION_VALUE]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_SYSTEM_STATUS]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_WORKFLOW_REASON]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_WORKFLOW_USER]: {
    type: 'keyword',
    array: false,
    required: false
  },
  // get these from ecs field map when available
  [_ruleDataUtils.ECS_VERSION]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.EVENT_ACTION]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.EVENT_KIND]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.TAGS]: {
    type: 'keyword',
    array: true,
    required: false
  }
};
exports.legacyAlertFieldMap = legacyAlertFieldMap;