"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snooze = snooze;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _authorization = require("../../authorization");
var _retry_if_conflicts = require("../../lib/retry_if_conflicts");
var _saved_objects = require("../../saved_objects");
var _audit_events = require("../common/audit_events");
var _validate_snooze_date = require("../../lib/validate_snooze_date");
var _rule_muted = require("../../lib/errors/rule_muted");
var _common = require("../common");
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function snooze(context, {
  id,
  snoozeSchedule
}) {
  const snoozeDateValidationMsg = (0, _validate_snooze_date.validateSnoozeStartDate)(snoozeSchedule.rRule.dtstart);
  if (snoozeDateValidationMsg) {
    throw new _rule_muted.RuleMutedError(snoozeDateValidationMsg);
  }
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.snooze('${id}', ${JSON.stringify(snoozeSchedule, null, 4)})`, async () => await snoozeWithOCC(context, {
    id,
    snoozeSchedule
  }));
}
async function snoozeWithOCC(context, {
  id,
  snoozeSchedule
}) {
  var _context$auditLogger2;
  const {
    attributes,
    version
  } = await context.unsecuredSavedObjectsClient.get('alert', id);
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.Snooze,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized('execute');
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.SNOOZE,
      savedObject: {
        type: 'alert',
        id
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.SNOOZE,
    outcome: 'unknown',
    savedObject: {
      type: 'alert',
      id
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);
  const newAttrs = (0, _common.getSnoozeAttributes)(attributes, snoozeSchedule);
  try {
    (0, _common.verifySnoozeScheduleLimit)(newAttrs);
  } catch (error) {
    throw _boom.default.badRequest(error.message);
  }
  const updateAttributes = (0, _lib.updateMeta)(context, {
    ...newAttrs,
    updatedBy: await context.getUserName(),
    updatedAt: new Date().toISOString()
  });
  const updateOptions = {
    version
  };
  await (0, _saved_objects.partiallyUpdateAlert)(context.unsecuredSavedObjectsClient, id, updateAttributes, updateOptions);
}