"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_TAGS_PER_PAGE = void 0;
exports.getTags = getTags;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _configSchema = require("@kbn/config-schema");
var _esQuery = require("@kbn/es-query");
var _authorization = require("../../authorization");
var _constants = require("../common/constants");
var _audit_events = require("../common/audit_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TAGS_PER_PAGE = 50;
exports.DEFAULT_TAGS_PER_PAGE = DEFAULT_TAGS_PER_PAGE;
const MAX_TAGS = 10000;
const getTagsParamsSchema = _configSchema.schema.object({
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: DEFAULT_TAGS_PER_PAGE,
    min: 1
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string())
});
async function getTags(context, params) {
  var _response$aggregation, _response$aggregation2;
  let validatedParams;
  try {
    validatedParams = getTagsParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Failed to validate params: ${error.message}`);
  }
  const {
    page,
    perPage = DEFAULT_TAGS_PER_PAGE,
    search = ''
  } = validatedParams;
  let authorizationTuple;
  try {
    authorizationTuple = await context.authorization.getFindAuthorizationFilter(_authorization.AlertingAuthorizationEntity.Rule, _constants.alertingAuthorizationFilterOpts);
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.AGGREGATE,
      error
    }));
    throw error;
  }
  const {
    filter: authorizationFilter
  } = authorizationTuple;
  const filter = authorizationFilter && search ? _esQuery.nodeBuilder.and([_esQuery.nodeBuilder.is('alert.attributes.tags', _esQuery.nodeTypes.wildcard.buildNode(`${search}*`)), authorizationFilter]) : authorizationFilter;
  const response = await context.unsecuredSavedObjectsClient.find({
    filter,
    type: 'alert',
    aggs: {
      tags: {
        terms: {
          field: 'alert.attributes.tags',
          order: {
            _key: 'asc'
          },
          size: MAX_TAGS
        }
      }
    }
  });
  const filteredTags = (((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.tags) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.buckets) || []).reduce((result, bucket) => {
    if (bucket.key.startsWith(search)) {
      result.push(bucket.key);
    }
    return result;
  }, []);
  const startIndex = (page - 1) * perPage;
  const endIndex = startIndex + perPage;
  const chunkedTags = filteredTags.slice(startIndex, endIndex);
  return {
    total: filteredTags.length,
    page,
    perPage,
    data: chunkedTags
  };
}