"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateLegacyActions = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _validate_actions = require("../validate_actions");
var _common = require("../../common");
var _retrieve_migrated_legacy_actions = require("./retrieve_migrated_legacy_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 * migrates SIEM legacy actions and merges rule actions and references
 * @param context RulesClient context
 * @param params
 * @returns
 */
const migrateLegacyActions = async (context, {
  ruleId,
  actions = [],
  references = [],
  attributes,
  skipActionsValidation
}) => {
  try {
    if (attributes.consumer !== _ruleDataUtils.AlertConsumers.SIEM) {
      return {
        resultedActions: [],
        hasLegacyActions: false,
        resultedReferences: []
      };
    }
    const {
      legacyActions,
      legacyActionsReferences
    } = await (0, _retrieve_migrated_legacy_actions.retrieveMigratedLegacyActions)(context, {
      ruleId
    });

    // sometimes we don't need to validate legacy actions. For example, when delete rules or update rule from payload
    if (skipActionsValidation !== true) {
      const ruleType = context.ruleTypeRegistry.get(attributes.alertTypeId);
      await (0, _validate_actions.validateActions)(context, ruleType, {
        ...attributes,
        // set to undefined to avoid both per-actin and rule level values clashing
        throttle: undefined,
        notifyWhen: undefined,
        actions: (0, _common.injectReferencesIntoActions)(ruleId, legacyActions, legacyActionsReferences)
      });
    }

    // fix references for a case when actions present in a rule
    if (actions.length) {
      legacyActions.forEach((legacyAction, i) => {
        const oldReference = legacyAction.actionRef;
        const legacyReference = legacyActionsReferences.find(({
          name
        }) => name === oldReference);
        const newReference = `action_${actions.length + i}`;
        legacyAction.actionRef = newReference;
        if (legacyReference) {
          legacyReference.name = newReference;
        }
      });
    }

    // put frequencies into existing actions
    // the situation when both action in rule nad legacy exist should be rare one
    // but if it happens, we put frequency in existing actions per-action level
    const existingActionsWithFrequencies = actions.map(action => {
      var _attributes$notifyWhe, _attributes$throttle;
      return {
        ...action,
        frequency: {
          summary: true,
          notifyWhen: (_attributes$notifyWhe = attributes.notifyWhen) !== null && _attributes$notifyWhe !== void 0 ? _attributes$notifyWhe : 'onActiveAlert',
          throttle: (_attributes$throttle = attributes.throttle) !== null && _attributes$throttle !== void 0 ? _attributes$throttle : null
        }
      };
    });
    return {
      resultedActions: [...existingActionsWithFrequencies, ...legacyActions],
      hasLegacyActions: legacyActions.length > 0,
      resultedReferences: [...references, ...legacyActionsReferences]
    };
  } catch (e) {
    context.logger.error(`migrateLegacyActions(): Failed to migrate legacy actions for SIEM rule ${ruleId}: ${e.message}`);
    return {
      resultedActions: [],
      hasLegacyActions: false,
      resultedReferences: []
    };
  }
};
exports.migrateLegacyActions = migrateLegacyActions;