"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyGetBulkRuleActionsSavedObject = exports.formatLegacyActions = void 0;
var _lodash = require("lodash");
var _pMap = _interopRequireDefault(require("p-map"));
var _common = require("../../common");
var _transform_to_notify_when = require("./transform_to_notify_when");
var _transform_legacy_actions = require("./transform_legacy_actions");
var _types = require("./types");
var _transform_to_alert_throttle = require("./transform_to_alert_throttle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 * this function finds all legacy actions associated with rules in bulk
 * it's useful for such methods as find, so we do not request legacy actions in a separate request per rule
 * @params params.alertIds - list of rule ids to look for legacy actions for
 * @params params.savedObjectsClient - savedObjectsClient
 * @params params.logger - logger
 * @returns map of legacy actions objects per rule with legacy actions
 */
const legacyGetBulkRuleActionsSavedObject = async ({
  alertIds,
  savedObjectsClient,
  logger
}) => {
  const references = alertIds.map(alertId => ({
    id: alertId,
    type: 'alert'
  }));
  const errors = [];
  const results = await (0, _pMap.default)((0, _lodash.chunk)(references, 1000), async referencesChunk => {
    try {
      return savedObjectsClient.find({
        // here we looking legacyRuleActionsSavedObjectType, as not all of rules create `siem.notifications`
        // more information on that can be found in https://github.com/elastic/kibana/pull/130511 PR
        type: _types.legacyRuleActionsSavedObjectType,
        perPage: 10000,
        hasReference: referencesChunk
      });
    } catch (error) {
      logger.error(`Error fetching rule actions: ${error instanceof Error ? error.message : String(error)}`);
      errors.push(error);
      return [];
    }
  }, {
    concurrency: 1
  });
  const actionSavedObjects = results.flat().flatMap(r => r.saved_objects);
  if (errors.length) {
    throw new AggregateError(errors, 'Error fetching rule actions');
  }
  return actionSavedObjects.reduce((acc, savedObject) => {
    const ruleAlertId = savedObject.references.find(reference => {
      // Find the first rule alert and assume that is the one we want since we should only ever have 1.
      return reference.type === 'alert';
    });
    // We check to ensure we have found a "ruleAlertId" and hopefully we have.
    const ruleAlertIdKey = ruleAlertId != null ? ruleAlertId.id : undefined;
    if (ruleAlertIdKey != null) {
      const legacyRawActions = (0, _transform_legacy_actions.transformFromLegacyActions)(savedObject.attributes, savedObject.references);
      acc[ruleAlertIdKey] = {
        ruleThrottle: savedObject.attributes.ruleThrottle,
        legacyRuleActions: (0, _common.injectReferencesIntoActions)(ruleAlertIdKey, legacyRawActions, savedObject.references) // remove uuid from action, as this uuid is not persistent
        .map(({
          uuid,
          ...action
        }) => action)
      };
    } else {
      logger.error(`Security Solution notification (Legacy) Was expecting to find a reference of type "alert" within ${savedObject.references} but did not. Skipping this notification.`);
    }
    return acc;
  }, {});
};

/**
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 * formats rules with associated SIEM legacy actions, if any legacy actions present
 * @param rules - list of rules to format
 * @param params - logger, savedObjectsClient
 * @returns
 */
exports.legacyGetBulkRuleActionsSavedObject = legacyGetBulkRuleActionsSavedObject;
const formatLegacyActions = async (rules, {
  logger,
  savedObjectsClient
}) => {
  try {
    const res = await legacyGetBulkRuleActionsSavedObject({
      alertIds: rules.map(rule => rule.id),
      savedObjectsClient,
      logger
    });
    return rules.map(rule => {
      var _ref;
      const legacyRuleActionsMatch = res[rule.id];
      if (!legacyRuleActionsMatch) {
        return rule;
      }
      const {
        legacyRuleActions,
        ruleThrottle
      } = legacyRuleActionsMatch;
      return {
        ...rule,
        actions: [...rule.actions, ...legacyRuleActions],
        throttle: (0, _transform_to_alert_throttle.transformToAlertThrottle)((_ref = legacyRuleActions.length ? ruleThrottle : rule.throttle) !== null && _ref !== void 0 ? _ref : 'no_actions'),
        notifyWhen: (0, _transform_to_notify_when.transformToNotifyWhen)(ruleThrottle),
        // muteAll property is disregarded in further rule processing in Security Solution when legacy actions are present.
        // So it should be safe to set it as false, so it won't be displayed to user as w/o actions see transformFromAlertThrottle method
        muteAll: legacyRuleActions.length ? false : rule.muteAll
      };
    });
  } catch (e) {
    const ruleIds = rules.map(rule => rule.id).join(', ');
    logger.error(`formatLegacyActions(): Failed to read legacy actions for SIEM rules ${ruleIds}: ${e.message}`);
    return rules;
  }
};
exports.formatLegacyActions = formatLegacyActions;