"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recoverRuleAlerts = void 0;
var _lodash = require("lodash");
var _server = require("@kbn/event-log-plugin/server");
var _apmUtils = require("@kbn/apm-utils");
var _alert_task_instance = require("../../task_runner/alert_task_instance");
var _alert = require("../../alert");
var _plugin = require("../../plugin");
var _create_alert_event_log_record_object = require("../../lib/create_alert_event_log_record_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recoverRuleAlerts = async (context, id, attributes) => {
  return (0, _apmUtils.withSpan)({
    name: 'recoverRuleAlerts',
    type: 'rules'
  }, async () => {
    if (!context.eventLogger || !attributes.scheduledTaskId) return;
    try {
      var _state$alertInstances;
      const {
        state
      } = (0, _alert_task_instance.taskInstanceToAlertTaskInstance)(await context.taskManager.get(attributes.scheduledTaskId), attributes);
      const recoveredAlerts = (0, _lodash.mapValues)((_state$alertInstances = state.alertInstances) !== null && _state$alertInstances !== void 0 ? _state$alertInstances : {}, (rawAlertInstance, alertId) => new _alert.Alert(alertId, rawAlertInstance));
      const recoveredAlertIds = Object.keys(recoveredAlerts);
      for (const alertId of recoveredAlertIds) {
        var _recoveredAlerts$aler;
        const {
          group: actionGroup
        } = (_recoveredAlerts$aler = recoveredAlerts[alertId].getLastScheduledActions()) !== null && _recoveredAlerts$aler !== void 0 ? _recoveredAlerts$aler : {};
        const instanceState = recoveredAlerts[alertId].getState();
        const message = `instance '${alertId}' has recovered due to the rule was disabled`;
        const alertUuid = recoveredAlerts[alertId].getUuid();
        const event = (0, _create_alert_event_log_record_object.createAlertEventLogRecordObject)({
          ruleId: id,
          ruleName: attributes.name,
          ruleRevision: attributes.revision,
          ruleType: context.ruleTypeRegistry.get(attributes.alertTypeId),
          consumer: attributes.consumer,
          instanceId: alertId,
          alertUuid,
          action: _plugin.EVENT_LOG_ACTIONS.recoveredInstance,
          message,
          state: instanceState,
          group: actionGroup,
          namespace: context.namespace,
          spaceId: context.spaceId,
          savedObjects: [{
            id,
            type: 'alert',
            typeId: attributes.alertTypeId,
            relation: _server.SAVED_OBJECT_REL_PRIMARY
          }]
        });
        context.eventLogger.logEvent(event);
      }
    } catch (error) {
      // this should not block the rest of the disable process
      context.logger.warn(`rulesClient.disable('${id}') - Could not write recovery events - ${error.message}`);
    }
  });
};
exports.recoverRuleAlerts = recoverRuleAlerts;