"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archiveMaintenanceWindowRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../lib");
var _types = require("../../types");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const bodySchema = _configSchema.schema.object({
  archive: _configSchema.schema.boolean()
});
const archiveMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}/_archive`,
    validate: {
      params: paramSchema,
      body: bodySchema
    },
    options: {
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const {
      id
    } = req.params;
    const {
      archive
    } = req.body;
    const maintenanceWindow = await maintenanceWindowClient.archive({
      id,
      archive
    });
    return res.ok({
      body: (0, _lib.rewritePartialMaintenanceBodyRes)(maintenanceWindow)
    });
  })));
};
exports.archiveMaintenanceWindowRoute = archiveMaintenanceWindowRoute;