"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _create = require("./methods/create");
var _get = require("./methods/get");
var _update = require("./methods/update");
var _find = require("./methods/find");
var _delete = require("./methods/delete");
var _archive = require("./methods/archive");
var _get_active_maintenance_windows = require("./methods/get_active_maintenance_windows");
var _finish = require("./methods/finish");
var _bulk_get = require("./methods/bulk_get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MaintenanceWindowClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "getUserName", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "create", params => (0, _create.create)(this.context, params));
    (0, _defineProperty2.default)(this, "get", params => (0, _get.get)(this.context, params));
    (0, _defineProperty2.default)(this, "update", params => (0, _update.update)(this.context, params));
    (0, _defineProperty2.default)(this, "find", () => (0, _find.find)(this.context));
    (0, _defineProperty2.default)(this, "delete", params => (0, _delete.deleteMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "archive", params => (0, _archive.archive)(this.context, params));
    (0, _defineProperty2.default)(this, "finish", params => (0, _finish.finish)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkGet", params => (0, _bulk_get.bulkGet)(this.context, params));
    (0, _defineProperty2.default)(this, "getActiveMaintenanceWindows", () => (0, _get_active_maintenance_windows.getActiveMaintenanceWindows)(this.context));
    this.logger = options.logger;
    this.savedObjectsClient = options.savedObjectsClient;
    this.getUserName = options.getUserName;
    this.context = {
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      getModificationMetadata: this.getModificationMetadata.bind(this)
    };
  }
  async getModificationMetadata() {
    const createTime = Date.now();
    const userName = await this.getUserName();
    return {
      createdBy: userName,
      updatedBy: userName,
      createdAt: new Date(createTime).toISOString(),
      updatedAt: new Date(createTime).toISOString()
    };
  }
}
exports.MaintenanceWindowClient = MaintenanceWindowClient;