"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindowFromRaw = void 0;
var _get_maintenance_window_date_and_status = require("./get_maintenance_window_date_and_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMaintenanceWindowFromRaw = ({
  id,
  attributes
}) => {
  const {
    events,
    expirationDate
  } = attributes;
  const {
    eventStartTime,
    eventEndTime,
    status
  } = (0, _get_maintenance_window_date_and_status.getMaintenanceWindowDateAndStatus)({
    events,
    expirationDate: new Date(expirationDate),
    dateToCompare: new Date()
  });
  return {
    ...attributes,
    id,
    eventStartTime,
    eventEndTime,
    status
  };
};
exports.getMaintenanceWindowFromRaw = getMaintenanceWindowFromRaw;