"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSnoozeActive = isSnoozeActive;
var _rrule = require("rrule");
var _rrule2 = require("../rrule");
var _timezone_helpers = require("./timezone_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TIMESTAMP = 8640000000000000;
function isSnoozeActive(snooze) {
  var _snooze$skipRecurrenc;
  const {
    duration,
    rRule,
    id
  } = snooze;
  if (duration === -1) return {
    id,
    snoozeEndTime: new Date(MAX_TIMESTAMP)
  };
  const startTimeMS = Date.parse(rRule.dtstart);
  const initialEndTime = startTimeMS + duration;
  const isInitialStartSkipped = (_snooze$skipRecurrenc = snooze.skipRecurrences) === null || _snooze$skipRecurrenc === void 0 ? void 0 : _snooze$skipRecurrenc.includes(rRule.dtstart);
  // If now is during the first occurrence of the snooze
  const now = Date.now();
  if (now >= startTimeMS && now < initialEndTime && !isInitialStartSkipped) return {
    snoozeEndTime: new Date(initialEndTime),
    lastOccurrence: new Date(rRule.dtstart),
    id
  };

  // Check to see if now is during a recurrence of the snooze

  const {
    tzid,
    ...restRRule
  } = rRule;
  const startDate = (0, _timezone_helpers.utcToLocalUtc)(new Date(rRule.dtstart), tzid);
  const nowDate = (0, _timezone_helpers.utcToLocalUtc)(new Date(now), tzid);
  try {
    var _snooze$skipRecurrenc2;
    const rRuleOptions = {
      ...restRRule,
      dtstart: startDate,
      until: rRule.until ? (0, _timezone_helpers.utcToLocalUtc)(new Date(rRule.until), tzid) : null,
      wkst: rRule.wkst ? _rrule.Weekday.fromStr(rRule.wkst) : null,
      byweekday: rRule.byweekday ? (0, _rrule2.parseByWeekday)(rRule.byweekday) : null
    };
    const recurrenceRule = new _rrule.RRule(rRuleOptions);
    const lastOccurrence = recurrenceRule.before(nowDate, true);
    if (!lastOccurrence) return null;
    // Check if the current recurrence has been skipped manually
    if ((_snooze$skipRecurrenc2 = snooze.skipRecurrences) !== null && _snooze$skipRecurrenc2 !== void 0 && _snooze$skipRecurrenc2.includes(lastOccurrence.toISOString())) return null;
    const lastOccurrenceEndTime = lastOccurrence.getTime() + duration;
    if (nowDate.getTime() < lastOccurrenceEndTime) return {
      lastOccurrence,
      snoozeEndTime: (0, _timezone_helpers.localUtcToUtc)(new Date(lastOccurrenceEndTime), tzid),
      id
    };
  } catch (e) {
    throw new Error(`Failed to process RRule ${rRule}: ${e}`);
  }
  return null;
}