"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRule = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatRule = ({
  rule,
  ruleType
}) => {
  return {
    kibana: {
      alert: {
        rule: {
          category: ruleType.name,
          consumer: rule.consumer,
          execution: {
            uuid: rule.executionId
          },
          name: rule.name,
          parameters: rule.parameters,
          producer: ruleType.producer,
          revision: rule.revision,
          rule_type_id: ruleType.id,
          tags: rule.tags,
          uuid: rule.id
        }
      },
      space_ids: [rule.spaceId]
    }
  };
};
exports.formatRule = formatRule;