"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUpdatedRecoveredAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates an existing recovered alert document with latest flapping
 * information
 */

const buildUpdatedRecoveredAlert = ({
  alert,
  legacyRawAlert,
  rule,
  timestamp
}) => {
  var _legacyRawAlert$meta, _legacyRawAlert$meta2, _rule$kibana;
  return _deepmerge.default.all([alert, {
    // Update the timestamp to reflect latest update time
    '@timestamp': timestamp,
    kibana: {
      alert: {
        // Set latest flapping state
        flapping: (_legacyRawAlert$meta = legacyRawAlert.meta) === null || _legacyRawAlert$meta === void 0 ? void 0 : _legacyRawAlert$meta.flapping,
        // Set latest flapping history
        flapping_history: (_legacyRawAlert$meta2 = legacyRawAlert.meta) === null || _legacyRawAlert$meta2 === void 0 ? void 0 : _legacyRawAlert$meta2.flappingHistory,
        // Set latest rule configuration
        rule: (_rule$kibana = rule.kibana) === null || _rule$kibana === void 0 ? void 0 : _rule$kibana.alert.rule
      }
    }
  }], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildUpdatedRecoveredAlert = buildUpdatedRecoveredAlert;