"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyAlertsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _alert = require("../alert/alert");
var _create_alert_factory = require("../alert/create_alert_factory");
var _lib = require("../lib");
var _trim_recovered_alerts = require("../lib/trim_recovered_alerts");
var _log_alerts = require("../task_runner/log_alerts");
var _rules_settings = require("../../common/rules_settings");
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LegacyAlertsClient {
  // Alerts from the previous execution that are deserialized from the task state

  // Alerts reported from the rule executor using the alert factory

  constructor(options) {
    (0, _defineProperty2.default)(this, "maxAlerts", _config.DEFAULT_MAX_ALERTS);
    (0, _defineProperty2.default)(this, "flappingSettings", _rules_settings.DEFAULT_FLAPPING_SETTINGS);
    (0, _defineProperty2.default)(this, "ruleLogPrefix", '');
    (0, _defineProperty2.default)(this, "trackedAlerts", {
      active: {},
      recovered: {}
    });
    (0, _defineProperty2.default)(this, "reportedAlerts", {});
    (0, _defineProperty2.default)(this, "processedAlerts", void 0);
    (0, _defineProperty2.default)(this, "alertFactory", void 0);
    this.options = options;
    this.processedAlerts = {
      new: {},
      active: {},
      activeCurrent: {},
      recovered: {},
      recoveredCurrent: {}
    };
  }
  async initializeExecution({
    maxAlerts,
    ruleLabel,
    flappingSettings,
    activeAlertsFromState,
    recoveredAlertsFromState
  }) {
    var _this$options$ruleTyp, _this$options$ruleTyp2;
    this.maxAlerts = maxAlerts;
    this.flappingSettings = flappingSettings;
    this.ruleLogPrefix = ruleLabel;
    for (const id of (0, _lodash.keys)(activeAlertsFromState)) {
      this.trackedAlerts.active[id] = new _alert.Alert(id, activeAlertsFromState[id]);
    }
    for (const id of (0, _lodash.keys)(recoveredAlertsFromState)) {
      this.trackedAlerts.recovered[id] = new _alert.Alert(id, recoveredAlertsFromState[id]);
    }

    // Legacy alerts client creates a copy of the active tracked alerts
    // This copy is updated when rule executors report alerts back to the framework
    // while the original alert is preserved
    this.reportedAlerts = (0, _lodash.cloneDeep)(this.trackedAlerts.active);
    this.alertFactory = (0, _create_alert_factory.createAlertFactory)({
      alerts: this.reportedAlerts,
      logger: this.options.logger,
      maxAlerts: this.maxAlerts,
      autoRecoverAlerts: (_this$options$ruleTyp = this.options.ruleType.autoRecoverAlerts) !== null && _this$options$ruleTyp !== void 0 ? _this$options$ruleTyp : true,
      canSetRecoveryContext: (_this$options$ruleTyp2 = this.options.ruleType.doesSetRecoveryContext) !== null && _this$options$ruleTyp2 !== void 0 ? _this$options$ruleTyp2 : false
    });
  }
  getTrackedAlerts() {
    return this.trackedAlerts;
  }
  getAlert(id) {
    var _this$alertFactory;
    return (_this$alertFactory = this.alertFactory) === null || _this$alertFactory === void 0 ? void 0 : _this$alertFactory.get(id);
  }
  processAndLogAlerts({
    eventLogger,
    ruleRunMetricsStore,
    shouldLogAlerts,
    flappingSettings,
    notifyWhen,
    maintenanceWindowIds
  }) {
    var _this$options$ruleTyp3, _this$options$ruleTyp4;
    const {
      newAlerts: processedAlertsNew,
      activeAlerts: processedAlertsActive,
      currentRecoveredAlerts: processedAlertsRecoveredCurrent,
      recoveredAlerts: processedAlertsRecovered
    } = (0, _lib.processAlerts)({
      alerts: this.reportedAlerts,
      existingAlerts: this.trackedAlerts.active,
      previouslyRecoveredAlerts: this.trackedAlerts.recovered,
      hasReachedAlertLimit: this.alertFactory.hasReachedAlertLimit(),
      alertLimit: this.maxAlerts,
      autoRecoverAlerts: (_this$options$ruleTyp3 = this.options.ruleType.autoRecoverAlerts) !== null && _this$options$ruleTyp3 !== void 0 ? _this$options$ruleTyp3 : true,
      flappingSettings,
      maintenanceWindowIds
    });
    const {
      trimmedAlertsRecovered,
      earlyRecoveredAlerts
    } = (0, _trim_recovered_alerts.trimRecoveredAlerts)(this.options.logger, processedAlertsRecovered, this.maxAlerts);
    const alerts = (0, _lib.getAlertsForNotification)(flappingSettings, notifyWhen, this.options.ruleType.defaultActionGroupId, processedAlertsNew, processedAlertsActive, trimmedAlertsRecovered, processedAlertsRecoveredCurrent);
    alerts.currentRecoveredAlerts = (0, _lodash.merge)(alerts.currentRecoveredAlerts, earlyRecoveredAlerts);
    this.processedAlerts.new = alerts.newAlerts;
    this.processedAlerts.active = alerts.activeAlerts;
    this.processedAlerts.activeCurrent = alerts.currentActiveAlerts;
    this.processedAlerts.recovered = alerts.recoveredAlerts;
    this.processedAlerts.recoveredCurrent = alerts.currentRecoveredAlerts;
    (0, _log_alerts.logAlerts)({
      logger: this.options.logger,
      alertingEventLogger: eventLogger,
      newAlerts: alerts.newAlerts,
      activeAlerts: alerts.currentActiveAlerts,
      recoveredAlerts: alerts.currentRecoveredAlerts,
      ruleLogPrefix: this.ruleLogPrefix,
      ruleRunMetricsStore,
      canSetRecoveryContext: (_this$options$ruleTyp4 = this.options.ruleType.doesSetRecoveryContext) !== null && _this$options$ruleTyp4 !== void 0 ? _this$options$ruleTyp4 : false,
      shouldPersistAlerts: shouldLogAlerts
    });
  }
  getProcessedAlerts(type) {
    if (this.processedAlerts.hasOwnProperty(type)) {
      return this.processedAlerts[type];
    }
    return {};
  }
  getAlertsToSerialize(shouldSetFlapping = true) {
    if (shouldSetFlapping) {
      (0, _lib.setFlapping)(this.flappingSettings, this.processedAlerts.active, this.processedAlerts.recovered);
    }
    return (0, _lib.determineAlertsToReturn)(this.processedAlerts.active, this.processedAlerts.recovered);
  }
  hasReachedAlertLimit() {
    return this.alertFactory.hasReachedAlertLimit();
  }
  checkLimitUsage() {
    return this.alertFactory.alertLimit.checkLimitUsage();
  }
  factory() {
    return (0, _create_alert_factory.getPublicAlertFactory)(this.alertFactory);
  }
  client() {
    return null;
  }
  async persistAlerts() {}
}
exports.LegacyAlertsClient = LegacyAlertsClient;