"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toString = exports.toMoment = exports.RecurringSchedule = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _get_weekday_info = require("../../helpers/get_weekday_info");
var _constants = require("../../constants");
var i18n = _interopRequireWildcard(require("../../translations"));
var _custom_recurring_schedule = require("./custom_recurring_schedule");
var _recurring_summary = require("../../helpers/recurring_summary");
var _get_presets = require("../../helpers/get_presets");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const toMoment = value => (0, _moment.default)(value);
exports.toMoment = toMoment;
const toString = value => value.toISOString();
exports.toString = toString;
const RecurringSchedule = /*#__PURE__*/_react.default.memo(() => {
  const [today] = (0, _react.useState)((0, _moment.default)());
  const [{
    startDate,
    endDate,
    timezone,
    recurringSchedule
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['startDate', 'endDate', 'timezone', 'recurringSchedule.frequency', 'recurringSchedule.interval', 'recurringSchedule.ends', 'recurringSchedule.until', 'recurringSchedule.count', 'recurringSchedule.customFrequency', 'recurringSchedule.byweekday', 'recurringSchedule.bymonth']
  });
  const {
    options,
    presets
  } = (0, _react.useMemo)(() => {
    if (!startDate) {
      return {
        options: _constants.DEFAULT_FREQUENCY_OPTIONS,
        presets: _constants.DEFAULT_PRESETS
      };
    }
    const date = (0, _moment.default)(startDate);
    const {
      dayOfWeek,
      nthWeekdayOfMonth,
      isLastOfMonth
    } = (0, _get_weekday_info.getWeekdayInfo)(date);
    return {
      options: [{
        text: i18n.CREATE_FORM_FREQUENCY_DAILY,
        value: _constants.Frequency.DAILY
      }, {
        text: i18n.CREATE_FORM_FREQUENCY_WEEKLY_ON(dayOfWeek),
        value: _constants.Frequency.WEEKLY
      }, {
        text: i18n.CREATE_FORM_FREQUENCY_NTH_WEEKDAY(dayOfWeek)[isLastOfMonth ? 0 : nthWeekdayOfMonth],
        value: _constants.Frequency.MONTHLY
      }, {
        text: i18n.CREATE_FORM_FREQUENCY_YEARLY_ON(date),
        value: _constants.Frequency.YEARLY
      }, {
        text: i18n.CREATE_FORM_FREQUENCY_CUSTOM,
        value: 'CUSTOM'
      }],
      presets: (0, _get_presets.getPresets)(date)
    };
  }, [startDate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.frequency",
    componentProps: {
      'data-test-subj': 'frequency-field',
      euiFieldProps: {
        options
      }
    }
  }), (recurringSchedule === null || recurringSchedule === void 0 ? void 0 : recurringSchedule.frequency) === _constants.Frequency.DAILY || (recurringSchedule === null || recurringSchedule === void 0 ? void 0 : recurringSchedule.frequency) === 'CUSTOM' ? /*#__PURE__*/_react.default.createElement(_custom_recurring_schedule.CustomRecurringSchedule, {
    "data-test-subj": "custom-recurring-form"
  }) : null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.ends",
    componentProps: {
      'data-test-subj': 'ends-field',
      euiFieldProps: {
        legend: 'Recurrence ends',
        options: _constants.RECURRENCE_END_OPTIONS
      }
    }
  }), (recurringSchedule === null || recurringSchedule === void 0 ? void 0 : recurringSchedule.ends) === _constants.EndsOptions.ON_DATE ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.until",
    config: {
      type: _hook_form_lib.FIELD_TYPES.DATE_PICKER,
      label: '',
      defaultValue: (0, _moment.default)(endDate).endOf('day').toISOString(),
      validations: [],
      serializer: toString,
      deserializer: toMoment
    },
    componentProps: {
      'data-test-subj': 'until-field',
      euiFieldProps: {
        showTimeSelect: false,
        minDate: today
      }
    }
  })), timezone ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "disabled-timezone-field",
    id: "disabled-timezone",
    isDisabled: true,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: [{
      label: timezone[0]
    }],
    isClearable: false,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      htmlFor: 'disabled-timezone'
    }, i18n.CREATE_FORM_TIMEZONE)
  })) : null)) : null, (recurringSchedule === null || recurringSchedule === void 0 ? void 0 : recurringSchedule.ends) === _constants.EndsOptions.AFTER_X ? /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurringSchedule.count",
    componentProps: {
      'data-test-subj': 'count-field',
      id: 'count',
      euiFieldProps: {
        type: 'number',
        min: 1,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'count'
        }, i18n.CREATE_FORM_COUNT_AFTER),
        append: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'count'
        }, i18n.CREATE_FORM_COUNT_OCCURRENCE)
      }
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, i18n.CREATE_FORM_RECURRING_SUMMARY_PREFIX((0, _recurring_summary.recurringSummary)((0, _moment.default)(startDate), recurringSchedule, presets))));
});
exports.RecurringSchedule = RecurringSchedule;
RecurringSchedule.displayName = 'RecurringSchedule';