"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearch = void 0;
var _search_utils = require("../application/utils/search_utils");
var _use_aiops_app_context = require("./use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearch = ({
  dataView,
  savedSearch
}, aiopsListState, readOnly = false) => {
  const {
    uiSettings,
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const searchData = (0, _search_utils.getEsQueryFromSavedSearch)({
    dataView,
    uiSettings,
    savedSearch,
    filterManager
  });
  if (searchData === undefined || aiopsListState && aiopsListState.searchString !== '') {
    if (aiopsListState !== null && aiopsListState !== void 0 && aiopsListState.filters && readOnly === false) {
      const globalFilters = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getGlobalFilters();
      if (filterManager) filterManager.setFilters(aiopsListState.filters);
      if (globalFilters) filterManager === null || filterManager === void 0 ? void 0 : filterManager.addFilters(globalFilters);
    }
    return {
      searchQuery: aiopsListState === null || aiopsListState === void 0 ? void 0 : aiopsListState.searchQuery,
      searchString: aiopsListState === null || aiopsListState === void 0 ? void 0 : aiopsListState.searchString,
      searchQueryLanguage: aiopsListState === null || aiopsListState === void 0 ? void 0 : aiopsListState.searchQueryLanguage
    };
  } else {
    return {
      searchQuery: searchData.searchQuery,
      searchString: searchData.searchString,
      searchQueryLanguage: searchData.queryLanguage
    };
  }
};
exports.useSearch = useSearch;