"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableItemAsKQL = void 0;
var _esQuery = require("@kbn/es-query");
var _mlAggUtils = require("@kbn/ml-agg-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTableItemAsKQL = tableItem => {
  if ((0, _mlAggUtils.isSignificantTerm)(tableItem)) {
    return `${(0, _esQuery.escapeKuery)(tableItem.fieldName)}:${(0, _esQuery.escapeKuery)(String(tableItem.fieldValue))}`;
  }
  return [...tableItem.groupItemsSortedByUniqueness.map(({
    fieldName,
    fieldValue
  }) => `${(0, _esQuery.escapeKuery)(fieldName)}:${(0, _esQuery.escapeKuery)(String(fieldValue))}`)].join(' AND ');
};
exports.getTableItemAsKQL = getTableItemAsKQL;