"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsPopover = FieldStatsPopover;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _public = require("@kbn/unified-field-list-plugin/public");
var _use_eui_theme = require("../../hooks/use_eui_theme");
var _field_stats_content = require("./field_stats_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldStatsPopover({
  dataView,
  dslQuery,
  fieldName,
  fieldValue,
  fieldStatsServices,
  timeRangeMs
}) {
  const [infoIsOpen, setInfoOpen] = (0, _react.useState)(false);
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const closePopover = (0, _react.useCallback)(() => setInfoOpen(false), []);
  const fieldForStats = (0, _react.useMemo)(() => (0, _mlIsDefined.isDefined)(fieldName) ? dataView.getFieldByName(fieldName) : undefined, [fieldName, dataView]);
  const trigger = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.fieldContextPopover.descriptionTooltipContent', {
      defaultMessage: 'Show top field values'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "inspect",
    onClick: ev => {
      setInfoOpen(!infoIsOpen);
    },
    "aria-label": _i18n.i18n.translate('xpack.aiops.fieldContextPopover.topFieldValuesAriaLabel', {
      defaultMessage: 'Show top field values'
    }),
    "data-test-subj": 'aiopsContextPopoverButton',
    css: {
      marginLeft: euiTheme.euiSizeXS
    }
  }));
  if (!fieldForStats) return null;
  return /*#__PURE__*/_react.default.createElement(_public.FieldPopover, {
    isOpen: infoIsOpen,
    closePopover: closePopover,
    button: trigger,
    renderHeader: () => /*#__PURE__*/_react.default.createElement(_public.FieldPopoverHeader, {
      field: fieldForStats,
      closePopover: closePopover
    }),
    renderContent: () => /*#__PURE__*/_react.default.createElement(_field_stats_content.FieldStatsContent, {
      field: fieldForStats,
      fieldName: fieldName,
      fieldValue: fieldValue,
      dataView: dataView,
      fieldStatsServices: fieldStatsServices,
      timeRangeMs: timeRangeMs,
      dslQuery: dslQuery
    })
  });
}