"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsControls = exports.FieldsConfig = exports.ChangePointResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _change_points_table = require("./change_points_table");
var _constants = require("./constants");
var _function_picker = require("./function_picker");
var _metric_field_selector = require("./metric_field_selector");
var _split_field_selector = require("./split_field_selector");
var _change_point_detection_context = require("./change_point_detection_context");
var _use_change_point_agg_request = require("./use_change_point_agg_request");
var _use_split_field_cardinality = require("./use_split_field_cardinality");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectControlCss = {
  width: '350px'
};

/**
 * Contains panels with controls and change point results.
 */
const FieldsConfig = () => {
  const {
    requestParams: {
      fieldConfigs
    },
    updateRequestParams,
    selectedChangePoints,
    setSelectedChangePoints
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const onChange = (0, _react.useCallback)((update, index) => {
    fieldConfigs.splice(index, 1, update);
    updateRequestParams({
      fieldConfigs
    });
  }, [updateRequestParams, fieldConfigs]);
  const onAdd = (0, _react.useCallback)(() => {
    const update = [...fieldConfigs];
    update.push(update[update.length - 1]);
    updateRequestParams({
      fieldConfigs: update
    });
  }, [updateRequestParams, fieldConfigs]);
  const onRemove = (0, _react.useCallback)(index => {
    fieldConfigs.splice(index, 1);
    updateRequestParams({
      fieldConfigs
    });
    delete selectedChangePoints[index];
    setSelectedChangePoints({
      ...selectedChangePoints
    });
  }, [updateRequestParams, fieldConfigs, setSelectedChangePoints, selectedChangePoints]);
  const onSelectionChange = (0, _react.useCallback)((update, index) => {
    setSelectedChangePoints({
      ...selectedChangePoints,
      [index]: update
    });
  }, [setSelectedChangePoints, selectedChangePoints]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldConfigs.map((fieldConfig, index) => {
    const key = index;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(FieldPanel, {
      "data-test-subj": `aiopsChangePointPanel_${index}`,
      fieldConfig: fieldConfig,
      onChange: value => onChange(value, index),
      onRemove: onRemove.bind(null, index),
      removeDisabled: fieldConfigs.length === 1,
      onSelectionChange: update => {
        onSelectionChange(update, index);
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onAdd,
    disabled: fieldConfigs.length >= _constants.MAX_CHANGE_POINT_CONFIGS,
    "data-test-subj": 'aiopsChangePointAddConfig'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.changePointDetection.addButtonLabel",
    defaultMessage: "Add"
  })));
};
exports.FieldsConfig = FieldsConfig;
/**
 * Components that combines field config and state for change point response.
 * @param fieldConfig
 * @param onChange
 * @param onRemove
 * @param removeDisabled
 * @constructor
 */
const FieldPanel = ({
  fieldConfig,
  onChange,
  onRemove,
  removeDisabled,
  onSelectionChange,
  'data-test-subj': dataTestSubj
}) => {
  const {
    combinedQuery,
    requestParams
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const splitFieldCardinality = (0, _use_split_field_cardinality.useSplitFieldCardinality)(fieldConfig.splitField, combinedQuery);
  const [isExpanded, setIsExpanded] = (0, _react.useState)(true);
  const {
    results: annotations,
    isLoading: annotationsLoading,
    progress
  } = (0, _use_change_point_agg_request.useChangePointResults)(fieldConfig, requestParams, combinedQuery, splitFieldCardinality);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    justifyContent: 'spaceBetween',
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    onClick: setIsExpanded.bind(null, prevState => !prevState),
    "aria-label": _i18n.i18n.translate('xpack.aiops.changePointDetection.expandConfigLabel', {
      defaultMessage: 'Expand configuration'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(FieldsControls, {
    fieldConfig: fieldConfig,
    onChange: onChange
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      visibility: progress === null ? 'hidden' : 'visible'
    },
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.changePointDetection.progressBarLabel",
      defaultMessage: "Fetching change points"
    }),
    value: progress !== null && progress !== void 0 ? progress : 0,
    max: 100,
    valueText: true,
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    disabled: removeDisabled,
    "aria-label": _i18n.i18n.translate('xpack.aiops.changePointDetection.removeConfigLabel', {
      defaultMessage: 'Remove configuration'
    }),
    iconType: "trash",
    color: "danger",
    onClick: onRemove
  }))), isExpanded ? /*#__PURE__*/_react.default.createElement(ChangePointResults, {
    fieldConfig: fieldConfig,
    isLoading: annotationsLoading,
    annotations: annotations,
    splitFieldCardinality: splitFieldCardinality,
    onSelectionChange: onSelectionChange
  }) : null);
};
/**
 * Renders controls for fields selection and emits updates on change.
 */
const FieldsControls = ({
  fieldConfig,
  onChange,
  children
}) => {
  const {
    splitFieldsOptions,
    combinedQuery
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    data,
    uiSettings,
    fieldFormats,
    charts,
    fieldStats
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  // required in order to trigger state updates
  (0, _mlDatePicker.useTimeRangeUpdates)();
  const timefilterActiveBounds = timefilter.getActiveBounds();
  const fieldStatsServices = (0, _react.useMemo)(() => {
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [uiSettings, data, fieldFormats, charts]);
  const FieldStatsFlyoutProvider = fieldStats.FieldStatsFlyoutProvider;
  const onChangeFn = (0, _react.useCallback)((field, value) => {
    const result = {
      ...fieldConfig,
      [field]: value
    };
    onChange(result);
  }, [onChange, fieldConfig]);
  return /*#__PURE__*/_react.default.createElement(FieldStatsFlyoutProvider, {
    fieldStatsServices: fieldStatsServices,
    dataView: dataView,
    dslQuery: combinedQuery,
    timeRangeMs: timefilterActiveBounds ? {
      from: timefilterActiveBounds.min.valueOf(),
      to: timefilterActiveBounds.max.valueOf()
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    responsive: true,
    wrap: true,
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_function_picker.FunctionPicker, {
    value: fieldConfig.fn,
    onChange: v => onChangeFn('fn', v)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: selectControlCss
  }, /*#__PURE__*/_react.default.createElement(_metric_field_selector.MetricFieldSelector, {
    value: fieldConfig.metricField,
    onChange: v => onChangeFn('metricField', v)
  })), splitFieldsOptions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: selectControlCss
  }, /*#__PURE__*/_react.default.createElement(_split_field_selector.SplitFieldSelector, {
    value: fieldConfig.splitField,
    onChange: v => onChangeFn('splitField', v)
  })) : null, children));
};
exports.FieldsControls = FieldsControls;
/**
 * Handles request and rendering results of the change point  with provided config.
 */
const ChangePointResults = ({
  fieldConfig,
  splitFieldCardinality,
  isLoading,
  annotations,
  onSelectionChange
}) => {
  const cardinalityExceeded = splitFieldCardinality && splitFieldCardinality > _constants.SPLIT_FIELD_CARDINALITY_LIMIT;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), cardinalityExceeded ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.aiops.changePointDetection.cardinalityWarningTitle', {
      defaultMessage: 'Analysis has been limited'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.aiops.changePointDetection.cardinalityWarningMessage', {
    defaultMessage: 'The "{splitField}" field cardinality is {cardinality} which exceeds the limit of {cardinalityLimit}. Only the first {cardinalityLimit} partitions, sorted by document count, are analyzed.',
    values: {
      cardinality: splitFieldCardinality,
      cardinalityLimit: _constants.SPLIT_FIELD_CARDINALITY_LIMIT,
      splitField: fieldConfig.splitField
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_change_points_table.ChangePointsTable, {
    annotations: annotations,
    fieldConfig: fieldConfig,
    isLoading: isLoading,
    onSelectionChange: onSelectionChange
  }));
};
exports.ChangePointResults = ChangePointResults;