"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldCodeEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MIN_DEFAULT_LINES_COUNT = 6;
const MAX_DEFAULT_LINES_COUNT = 30;
const FieldCodeEditor = ({
  value,
  onChange,
  type,
  isReadOnly,
  a11yProps,
  name
}) => {
  // setting editor height based on lines height and count to stretch and fit its content
  const setEditorCalculatedHeight = (0, _react.useCallback)(editor => {
    var _editor$getModel;
    const editorElement = editor.getDomNode();
    if (!editorElement) {
      return;
    }
    const lineHeight = editor.getOption(_monaco.monaco.editor.EditorOption.lineHeight);
    let lineCount = ((_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.getLineCount()) || MIN_DEFAULT_LINES_COUNT;
    if (lineCount < MIN_DEFAULT_LINES_COUNT) {
      lineCount = MIN_DEFAULT_LINES_COUNT;
    } else if (lineCount > MAX_DEFAULT_LINES_COUNT) {
      lineCount = MAX_DEFAULT_LINES_COUNT;
    }
    const height = lineHeight * lineCount;
    editorElement.id = name;
    editorElement.style.height = `${height}px`;
    editor.layout();
  }, [name]);
  const trimEditorBlankLines = (0, _react.useCallback)(editor => {
    const editorModel = editor.getModel();
    if (!editorModel) {
      return;
    }
    const trimmedValue = editorModel.getValue().trim();
    editorModel.setValue(trimmedValue);
  }, []);
  const editorDidMount = (0, _react.useCallback)(editor => {
    setEditorCalculatedHeight(editor);
    editor.onDidChangeModelContent(() => {
      setEditorCalculatedHeight(editor);
    });
    editor.onDidBlurEditorWidget(() => {
      trimEditorBlankLines(editor);
    });
  }, [setEditorCalculatedHeight, trimEditorBlankLines]);
  return /*#__PURE__*/_react.default.createElement(_public.CodeEditor, (0, _extends2.default)({}, a11yProps, {
    languageId: type === 'json' ? _monaco.XJsonLang.ID : _public.MarkdownLang,
    value: value,
    onChange: onChange,
    editorDidMount: editorDidMount,
    width: "100%",
    options: {
      readOnly: isReadOnly,
      lineNumbers: 'off',
      scrollBeyondLastLine: false,
      automaticLayout: true,
      folding: false,
      tabSize: 2,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    }
  }));
};
exports.FieldCodeEditor = FieldCodeEditor;