"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsVoiceAnnouncement = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
    This component aims to insert assertive live region on the page,
    to make sure that a screen reader announces layout changes.

    Due to the fact that it has a specific way of detecting what-and-when announce
    as well as delay of announcement (which depends on what a user is doing at the moment)
    I place a 500ms delay of re-render the text of anouncement.
    That time period is best fits the time of screen reader reaction.
    That anouncement depends on what user is typying into search box as well as
    the speed of ordinary screen reader pronouns what user is typing before start reading this anouncement.

    The order of triggering functions:
    1: React trigs the component to be updated
    2: It places a timer and block render
    3: The time is over
    4: Component renders

    5: If there is another component call, the timer is dropped (cleared).
 */

class AdvancedSettingsVoiceAnnouncement extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "shouldComponentUpdate", nextProps => {
      /*
        If a user typed smth new, we should clear the previous timer
        and start another one + block component rendering.
         When it is reset and delaying is over as well as no new string came,
        it's ready to be rendered.
      */
      return nextProps.queryText !== this.props.queryText;
    });
  }
  render() {
    const filteredSections = Object.values(this.props.settings).map(setting => setting.map(option => option.ariaName));
    const filteredOptions = [...filteredSections];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("div", {
      role: "region",
      "aria-live": "polite",
      "aria-label": _i18n.i18n.translate('advancedSettings.voiceAnnouncement.ariaLabel', {
        defaultMessage: 'Advanced Settings results info'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, this.props.queryText ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "advancedSettings.voiceAnnouncement.searchResultScreenReaderMessage",
      defaultMessage: "You searched for {query}. There {optionLenght, plural, one {is # option} other {are # options}} in {sectionLenght, plural, one {# section} other {# sections}}",
      values: {
        query: this.props.queryText,
        sectionLenght: filteredSections.length,
        optionLenght: filteredOptions.length
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "advancedSettings.voiceAnnouncement.noSearchResultScreenReaderMessage",
      defaultMessage: "There {optionLenght, plural, one {is # option} other {are # options}} in {sectionLenght, plural, one {# section} other {# sections}}",
      values: {
        sectionLenght: filteredSections.length,
        optionLenght: filteredOptions.length
      }
    }))));
  }
}
exports.AdvancedSettingsVoiceAnnouncement = AdvancedSettingsVoiceAnnouncement;