"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustacheLambdas = getMustacheLambdas;
var tinymath = _interopRequireWildcard(require("@kbn/tinymath"));
var _hjson = require("hjson");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _number_formatter = require("./number_formatter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultDateTimeZone = 'UTC';
const DefaultDateFormat = 'YYYY-MM-DD hh:mma';
function getMustacheLambdas() {
  return getLambdas();
}
const TimeZoneSet = new Set(_momentTimezone.default.tz.names());
function getLambdas() {
  return {
    EvalMath: () =>
    // mustache invokes lamdas with `this` set to the current "view" (variables)
    function (text, render) {
      return evalMath(this, render(text.trim()));
    },
    ParseHjson: () => function (text, render) {
      return parseHjson(render(text.trim()));
    },
    FormatDate: () => function (text, render) {
      const dateString = render(text.trim()).trim();
      return formatDate(dateString);
    },
    FormatNumber: () => function (text, render) {
      const numberString = render(text.trim()).trim();
      return (0, _number_formatter.formatNumber)(numberString);
    }
  };
}
function evalMath(vars, o) {
  const expr = `${o}`;
  try {
    const result = tinymath.evaluate(expr, vars);
    return `${result}`;
  } catch (err) {
    throw new Error(`error evaluating tinymath expression "${expr}": ${err.message}`);
  }
}
function parseHjson(o) {
  const hjsonObject = `${o}`;
  let object;
  try {
    object = (0, _hjson.parse)(hjsonObject);
  } catch (err) {
    throw new Error(`error parsing Hjson "${hjsonObject}": ${err.message}`);
  }
  return JSON.stringify(object);
}
function formatDate(dateString) {
  const {
    date,
    timeZone,
    format
  } = splitDateString(`${dateString}`);
  if (date === '') {
    throw new Error(`date is empty`);
  }
  if (isNaN(new Date(date).valueOf())) {
    throw new Error(`invalid date "${date}"`);
  }
  let mDate;
  try {
    mDate = (0, _momentTimezone.default)(date);
    if (!mDate.isValid()) {
      throw new Error(`date is invalid`);
    }
  } catch (err) {
    throw new Error(`error evaluating moment date "${date}": ${err.message}`);
  }
  if (!TimeZoneSet.has(timeZone)) {
    throw new Error(`unknown timeZone value "${timeZone}"`);
  }
  try {
    mDate.tz(timeZone);
  } catch (err) {
    throw new Error(`error evaluating moment timeZone "${timeZone}": ${err.message}`);
  }
  try {
    return mDate.format(format);
  } catch (err) {
    throw new Error(`error evaluating moment format "${format}": ${err.message}`);
  }
}
function splitDateString(dateString) {
  const parts = dateString.split(';', 3).map(s => s.trim());
  const [date = '', timeZone = '', format = ''] = parts;
  return {
    date,
    timeZone: timeZone || DefaultDateTimeZone,
    format: format || DefaultDateFormat
  };
}