"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmailActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmailActionFields = ({
  action,
  editAction,
  errors,
  hasErrors
}) => {
  const {
    to,
    subject,
    body
  } = action;
  const toOptions = to ? to.map(label => ({
    label
  })) : [];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "emailRecipient",
    errorKey: "to",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && to !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.recipientTextFieldLabel', {
      defaultMessage: 'To email address'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    "data-test-subj": "toEmailAddressInput",
    selectedOptions: toOptions,
    onCreateOption: searchValue => {
      const newOptions = [...toOptions, {
        label: searchValue
      }];
      editAction({
        key: 'to',
        value: newOptions.map(newOption => newOption.label)
      });
    },
    onChange: selectedOptions => {
      editAction({
        key: 'to',
        value: selectedOptions.map(selectedOption => selectedOption.label)
      });
    },
    onBlur: () => {
      if (!to) {
        editAction({
          key: 'to',
          value: []
        });
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.subjectTextFieldLabel', {
      defaultMessage: 'Subject (optional)'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "subject",
    "data-test-subj": "emailSubjectInput",
    value: subject || '',
    onChange: e => {
      editAction({
        key: 'subject',
        value: e.target.value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.bodyTextAreaFieldLabel', {
      defaultMessage: 'Body'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: body || '',
    name: "body",
    "data-test-subj": "emailBodyInput",
    onChange: e => {
      editAction({
        key: 'body',
        value: e.target.value
      });
    }
  })));
};
exports.EmailActionFields = EmailActionFields;