"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _sections = require("./sections");
var _navigation = require("./lib/navigation");
var _app_context = require("./app_context");
var _license_prompt = require("./license_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShareRouter = (0, _reactRouterDom.withRouter)(({
  children,
  history
}) => {
  (0, _navigation.registerRouter)({
    history
  });
  return children;
});
const App = deps => {
  const [{
    valid,
    message
  }, setLicenseStatus] = (0, _react.useState)({
    valid: true
  });
  (0, _react.useEffect)(() => {
    const s = deps.licenseStatus$.subscribe(setLicenseStatus);
    return () => s.unsubscribe();
  }, [deps.licenseStatus$]);
  if (!valid) {
    return /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      licenseManagementLocator: deps.licenseManagementLocator,
      message: message
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: deps.history
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.CompatRouter, null, /*#__PURE__*/_react.default.createElement(ShareRouter, null, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: deps
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, null)))));
};

// Export this so we can test it with a different router.
exports.App = App;
const AppWithoutRouter = () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches",
  component: _sections.WatchListPage
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/watch/:id/status",
  component: _sections.WatchStatusPage
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/watch/:id/edit",
  component: _sections.WatchEditPage
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/watches/new-watch/:type(json|threshold)",
  component: _sections.WatchEditPage
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  exact: true,
  from: "/",
  to: "/watches"
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  exact: true,
  from: "",
  to: "/watches"
}));
exports.AppWithoutRouter = AppWithoutRouter;