"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _dialog_navigation = require("../dialog_navigation");
var _show_saved_object = require("./show_saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SearchSelection extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "fixedPageSize", 8);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newVisWizard.newVisTypeTitle",
      defaultMessage: "New {visTypeName}",
      values: {
        visTypeName: this.props.visType.title
      }
    }), ' ', "/", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visualizations.newVisWizard.chooseSourceTitle",
      defaultMessage: "Choose a source"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_dialog_navigation.DialogNavigation, {
      goBack: this.props.goBack
    }), /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
      key: "searchSavedObjectFinder",
      onChoose: this.props.onSearchSelected,
      showFilter: true,
      noItemsMessage: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.notFoundLabel', {
        defaultMessage: 'No matching indices or saved searches found.'
      }),
      savedObjectMetaData: [{
        type: 'search',
        getIconForSavedObject: () => 'search',
        name: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.savedObjectType.search', {
          defaultMessage: 'Saved search'
        }),
        // ignore the saved searches that have text-based languages queries
        includeFields: ['isTextBasedQuery', 'usesAdHocDataView'],
        showSavedObject: _show_saved_object.showSavedObject
      }, {
        type: 'index-pattern',
        getIconForSavedObject: () => 'indexPatternApp',
        name: _i18n.i18n.translate('visualizations.newVisWizard.searchSelection.savedObjectType.dataView', {
          defaultMessage: 'Data view'
        }),
        defaultSearchField: 'name'
      }],
      fixedPageSize: this.fixedPageSize,
      services: {
        uiSettings: this.props.uiSettings,
        http: this.props.http,
        savedObjectsManagement: this.props.savedObjectsManagement
      }
    })));
  }
}
exports.SearchSelection = SearchSelection;