"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseVisType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _vis_groups_enum = require("./vis_groups_enum");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultOptions = {
  showTimePicker: true,
  showFilterBar: true,
  showIndexSelection: true,
  showQueryInput: true,
  hierarchicalData: false // we should get rid of this i guess ?
};

class BaseVisType {
  constructor(opts) {
    var _opts$description, _opts$note, _opts$stage, _opts$isDeprecated, _opts$group, _opts$titleInWizard, _opts$disableCreate, _opts$disableEdit, _opts$requiresSearch, _opts$hasPartialRows, _opts$hierarchicalDat, _opts$fetchDatatable, _this$editorConfig$sc, _this$editorConfig;
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    (0, _defineProperty2.default)(this, "note", void 0);
    (0, _defineProperty2.default)(this, "getSupportedTriggers", void 0);
    (0, _defineProperty2.default)(this, "navigateToLens", void 0);
    (0, _defineProperty2.default)(this, "getExpressionVariables", void 0);
    (0, _defineProperty2.default)(this, "icon", void 0);
    (0, _defineProperty2.default)(this, "image", void 0);
    (0, _defineProperty2.default)(this, "stage", void 0);
    (0, _defineProperty2.default)(this, "isDeprecated", void 0);
    (0, _defineProperty2.default)(this, "group", void 0);
    (0, _defineProperty2.default)(this, "titleInWizard", void 0);
    (0, _defineProperty2.default)(this, "options", void 0);
    (0, _defineProperty2.default)(this, "visConfig", void 0);
    (0, _defineProperty2.default)(this, "editorConfig", void 0);
    (0, _defineProperty2.default)(this, "disableCreate", void 0);
    (0, _defineProperty2.default)(this, "disableEdit", void 0);
    (0, _defineProperty2.default)(this, "requiresSearch", void 0);
    (0, _defineProperty2.default)(this, "suppressWarnings", void 0);
    (0, _defineProperty2.default)(this, "hasPartialRows", void 0);
    (0, _defineProperty2.default)(this, "hierarchicalData", void 0);
    (0, _defineProperty2.default)(this, "setup", void 0);
    (0, _defineProperty2.default)(this, "getUsedIndexPattern", void 0);
    (0, _defineProperty2.default)(this, "inspectorAdapters", void 0);
    (0, _defineProperty2.default)(this, "fetchDatatable", void 0);
    (0, _defineProperty2.default)(this, "toExpressionAst", void 0);
    (0, _defineProperty2.default)(this, "getInfoMessage", void 0);
    (0, _defineProperty2.default)(this, "updateVisTypeOnParamsChange", void 0);
    (0, _defineProperty2.default)(this, "schemas", void 0);
    if (!opts.icon && !opts.image) {
      throw new Error('vis_type must define its icon or image');
    }
    this.name = opts.name;
    this.description = (_opts$description = opts.description) !== null && _opts$description !== void 0 ? _opts$description : '';
    this.note = (_opts$note = opts.note) !== null && _opts$note !== void 0 ? _opts$note : '';
    this.getSupportedTriggers = opts.getSupportedTriggers;
    this.navigateToLens = opts.navigateToLens;
    this.getExpressionVariables = opts.getExpressionVariables;
    this.title = opts.title;
    this.icon = opts.icon;
    this.image = opts.image;
    this.suppressWarnings = opts.suppressWarnings;
    this.visConfig = (0, _lodash.defaultsDeep)({}, opts.visConfig, {
      defaults: {}
    });
    this.editorConfig = (0, _lodash.defaultsDeep)({}, opts.editorConfig, {
      collections: {}
    });
    this.options = (0, _lodash.defaultsDeep)({}, opts.options, defaultOptions);
    this.stage = (_opts$stage = opts.stage) !== null && _opts$stage !== void 0 ? _opts$stage : 'production';
    this.isDeprecated = (_opts$isDeprecated = opts.isDeprecated) !== null && _opts$isDeprecated !== void 0 ? _opts$isDeprecated : false;
    this.group = (_opts$group = opts.group) !== null && _opts$group !== void 0 ? _opts$group : _vis_groups_enum.VisGroups.AGGBASED;
    this.titleInWizard = (_opts$titleInWizard = opts.titleInWizard) !== null && _opts$titleInWizard !== void 0 ? _opts$titleInWizard : '';
    this.disableCreate = (_opts$disableCreate = opts.disableCreate) !== null && _opts$disableCreate !== void 0 ? _opts$disableCreate : false;
    this.disableEdit = (_opts$disableEdit = opts.disableEdit) !== null && _opts$disableEdit !== void 0 ? _opts$disableEdit : false;
    this.requiresSearch = (_opts$requiresSearch = opts.requiresSearch) !== null && _opts$requiresSearch !== void 0 ? _opts$requiresSearch : false;
    this.setup = opts.setup;
    this.hasPartialRows = (_opts$hasPartialRows = opts.hasPartialRows) !== null && _opts$hasPartialRows !== void 0 ? _opts$hasPartialRows : false;
    this.hierarchicalData = (_opts$hierarchicalDat = opts.hierarchicalData) !== null && _opts$hierarchicalDat !== void 0 ? _opts$hierarchicalDat : false;
    this.getUsedIndexPattern = opts.getUsedIndexPattern;
    this.inspectorAdapters = opts.inspectorAdapters;
    this.fetchDatatable = (_opts$fetchDatatable = opts.fetchDatatable) !== null && _opts$fetchDatatable !== void 0 ? _opts$fetchDatatable : false;
    this.toExpressionAst = opts.toExpressionAst;
    this.getInfoMessage = opts.getInfoMessage;
    this.updateVisTypeOnParamsChange = opts.updateVisTypeOnParamsChange;
    this.schemas = new _schemas.Schemas((_this$editorConfig$sc = (_this$editorConfig = this.editorConfig) === null || _this$editorConfig === void 0 ? void 0 : _this$editorConfig.schemas) !== null && _this$editorConfig$sc !== void 0 ? _this$editorConfig$sc : []);
  }
}
exports.BaseVisType = BaseVisType;