"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuery = exports.isQueryValid = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const validateQuery = (input, dataView) => {
  let isValid = true;
  let error;
  try {
    if (input) {
      if (input.language === 'kuery') {
        (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(input.query), dataView);
      } else {
        (0, _esQuery.luceneStringToDsl)(input.query);
      }
    }
  } catch (e) {
    isValid = false;
    error = e.message;
  }
  return {
    isValid,
    error
  };
};
exports.validateQuery = validateQuery;
const isQueryValid = (input, dataView) => validateQuery(input, dataView).isValid;
exports.isQueryValid = isQueryValid;