"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _debounced_input = require("./debounced_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NameInput = ({
  value,
  onChange,
  defaultValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visualizationUiComponents.nameInput.columnLabel', {
      defaultMessage: 'Name',
      description: 'Name of a column of data'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_debounced_input.DebouncedInput, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "name-input",
    value: value,
    onChange: onChange,
    defaultValue: defaultValue
  }));
};
exports.NameInput = NameInput;