"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteIndicator = PaletteIndicator;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PaletteIndicator({
  accessorConfig
}) {
  if (accessorConfig.triggerIconType !== 'colorBy' || !accessorConfig.palette) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    className: "lnsLayerPanel__palette",
    css: (0, _react2.css)`
          height: ${_uiTheme.euiThemeVars.euiSizeXS} / 2;
          border-radius: 0 0 (${_uiTheme.euiThemeVars.euiBorderRadius} - 1px)
            (${_uiTheme.euiThemeVars.euiBorderRadius} - 1px);

          &::after {
            border: none;
          }
        `,
    size: "xs",
    palette: accessorConfig.palette
  }));
}