"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _tooltip_wrapper = require("./tooltip_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const tooltipContent = {
  auto: _i18n.i18n.translate('visualizationUiComponents.colorPicker.tooltip.auto', {
    defaultMessage: 'Lens automatically picks colors for you unless you specify a custom color.'
  }),
  custom: _i18n.i18n.translate('visualizationUiComponents.colorPicker.tooltip.custom', {
    defaultMessage: 'Clear the custom color to return to “Auto” mode.'
  }),
  disabled: _i18n.i18n.translate('visualizationUiComponents.colorPicker.tooltip.disabled', {
    defaultMessage: 'You are unable to apply custom colors to individual series when the layer includes a "Break down by" field.'
  })
};
const ColorPicker = ({
  label,
  disableHelpTooltip,
  disabled,
  setConfig,
  defaultColor,
  overwriteColor,
  showAlpha
}) => {
  const [colorText, setColorText] = (0, _react.useState)(overwriteColor || defaultColor);
  const [validatedColor, setValidatedColor] = (0, _react.useState)(overwriteColor || defaultColor);
  const [currentColorAlpha, setCurrentColorAlpha] = (0, _react.useState)((0, _coloring.getColorAlpha)(colorText));
  const unflushedChanges = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    //  only the changes from outside the color picker should be applied
    if (!unflushedChanges.current) {
      // something external changed the color that is currently selected (switching from annotation line to annotation range)
      if (overwriteColor && validatedColor && overwriteColor.toUpperCase() !== validatedColor.toUpperCase()) {
        setColorText(overwriteColor);
        setValidatedColor(overwriteColor.toUpperCase());
        setCurrentColorAlpha((0, _coloring.getColorAlpha)(overwriteColor));
      }
    }
    unflushedChanges.current = false;
  }, [validatedColor, overwriteColor, defaultColor]);
  const handleColor = (text, output) => {
    setColorText(text);
    unflushedChanges.current = true;
    if (output.isValid) {
      setValidatedColor(output.hex.toUpperCase());
      setCurrentColorAlpha((0, _coloring.getColorAlpha)(output.hex));
      setConfig({
        color: output.hex
      });
    }
    if (text === '') {
      setConfig({
        color: undefined
      });
    }
  };
  const inputLabel = label !== null && label !== void 0 ? label : _i18n.i18n.translate('visualizationUiComponents.colorPicker.seriesColor.label', {
    defaultMessage: 'Series color'
  });
  const colorPicker = /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    fullWidth: true,
    "data-test-subj": "indexPattern-dimension-colorPicker",
    compressed: true,
    isClearable: Boolean(overwriteColor),
    onChange: handleColor,
    color: disabled ? '' : colorText,
    disabled: disabled,
    placeholder: (defaultColor === null || defaultColor === void 0 ? void 0 : defaultColor.toUpperCase()) || _i18n.i18n.translate('visualizationUiComponents.colorPicker.seriesColor.auto', {
      defaultMessage: 'Auto'
    }),
    "aria-label": inputLabel,
    showAlpha: showAlpha,
    swatches: currentColorAlpha === 1 ? (0, _eui.euiPaletteColorBlind)() : (0, _eui.euiPaletteColorBlind)().map(c => (0, _coloring.makeColorWithAlpha)(c, currentColorAlpha).hex())
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
      delay: "long",
      position: "top",
      tooltipContent: colorText && !disabled ? tooltipContent.custom : tooltipContent.auto,
      condition: !disableHelpTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, inputLabel, !disableHelpTooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued",
      size: "s",
      className: "eui-alignTop"
    }))))
  }, disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent.disabled,
    delay: "long",
    anchorClassName: "eui-displayBlock"
  }, colorPicker) : colorPicker);
};
exports.ColorPicker = ColorPicker;