"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartOptions = ChartOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _line_options = require("./line_options");
var _point_options = require("./point_options");
var _common = require("../../../../../common");
var _collections = require("../../../collections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const collections = (0, _collections.getConfigCollections)();
function ChartOptions({
  chart,
  index,
  valueAxes,
  changeValueAxis,
  setParamByIndex
}) {
  const setChart = (0, _react.useCallback)((paramName, value) => {
    setParamByIndex('seriesParams', index, paramName, value);
  }, [setParamByIndex, index]);
  const setValueAxis = (0, _react.useCallback)((paramName, value) => {
    changeValueAxis(index, paramName, value);
  }, [changeValueAxis, index]);
  const valueAxesOptions = (0, _react.useMemo)(() => [...valueAxes.map(({
    id,
    name
  }) => ({
    text: name,
    value: id
  })), {
    text: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.newAxisLabel', {
      defaultMessage: 'New axis…'
    }),
    value: 'new'
  }], [valueAxes]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesValueAxis${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.valueAxisLabel', {
      defaultMessage: 'Value axis'
    }),
    options: valueAxesOptions,
    paramName: "valueAxis",
    value: chart.valueAxis,
    setValue: setValueAxis
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesType${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.chartTypeLabel', {
      defaultMessage: 'Chart type'
    }),
    options: collections.chartTypes,
    paramName: "type",
    value: chart.type,
    setValue: setChart
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesMode${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.modeLabel', {
      defaultMessage: 'Mode'
    }),
    options: collections.chartModes,
    paramName: "mode",
    value: chart.mode,
    setValue: setChart
  }))), chart.type === _common.ChartType.Area && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: collections.interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart
  })), chart.type === _common.ChartType.Line && /*#__PURE__*/_react.default.createElement(_line_options.LineOptions, {
    chart: chart,
    setChart: setChart
  }), (chart.type === _common.ChartType.Area || chart.type === _common.ChartType.Line) && /*#__PURE__*/_react.default.createElement(_point_options.PointOptions, {
    chart: chart,
    setChart: setChart
  }));
}