"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _inspector_data_grid = require("./inspector_data_grid");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDataGridArialabel = view => _i18n.i18n.translate('visTypeVega.inspector.dataViewer.gridAriaLabel', {
  defaultMessage: '{name} data grid',
  values: {
    name: view.id
  }
});
const dataSetAriaLabel = _i18n.i18n.translate('visTypeVega.inspector.dataViewer.dataSetAriaLabel', {
  defaultMessage: 'Data set'
});
const DataViewer = ({
  vegaAdapter,
  ...rest
}) => {
  const [inspectDataSets, setInspectDataSets] = (0, _react.useState)([]);
  const [selectedView, setSelectedView] = (0, _react.useState)();
  const [dataGridAriaLabel, setDataGridAriaLabel] = (0, _react.useState)('');
  const onViewChange = (0, _react.useCallback)(selectedOptions => {
    const newView = inspectDataSets.find(view => view.id === selectedOptions[0].label);
    if (newView) {
      setDataGridAriaLabel(getDataGridArialabel(newView));
      setSelectedView(newView);
    }
  }, [inspectDataSets]);
  (0, _react.useEffect)(() => {
    const subscription = vegaAdapter.getDataSetsSubscription().subscribe(dataSets => {
      setInspectDataSets(dataSets);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [vegaAdapter]);
  (0, _react.useEffect)(() => {
    if (inspectDataSets) {
      if (!selectedView) {
        setSelectedView(inspectDataSets[0]);
      } else {
        setDataGridAriaLabel(getDataGridArialabel(selectedView));
      }
    }
  }, [selectedView, inspectDataSets]);
  if (!selectedView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    options: inspectDataSets.map(item => ({
      label: item.id
    })),
    "aria-label": dataSetAriaLabel,
    onChange: onViewChange,
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: [{
      label: selectedView.id
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_inspector_data_grid.InspectorDataGrid, {
    columns: selectedView.columns,
    data: selectedView.data,
    dataGridAriaLabel: dataGridAriaLabel
  })));
};
exports.DataViewer = DataViewer;